create database "home.gdb";

create table employee
(
   empno  integer,
   empname  varchar(30)
);

create table emp_change
(
   empno  integer,
   change_type  varchar(4),
   seqno  integer
);
create generator empno_gen;
create generator seqno_gen;

set term !! ;
create trigger create_empno for employee
before insert as
begin
  new.empno=gen_id(empno_gen,1);
end !!
create trigger emp_ins for employee
after insert as
begin
   insert into emp_change values (new.empno,"INS",0);
end !!
create trigger emp_upd for employee
before update as
begin
   insert into emp_change values (old.empno,"UPD",0);
end !!
create trigger emp_del for employee
before delete as
begin
   insert into emp_change values (old.empno,"DEL",0);
end !!
create trigger create_seqno for emp_change
before insert as
begin
  new.seqno=gen_id(seqno_gen,1);
end !!
set term ; !!
