exec sql
   set database r_db = "remote.gdb";
exec sql
   set database h_db = "home.gdb";

exec sql
   begin declare section;
      long *tx1,*tx2=0;
      int empno,seqno;
      char empname[31],chg_type[4];
exec sql
   end declare section;

main()
{
   exec sql
     connect all;

   exec sql
     set transaction name tx1 using h_db;

   exec sql
      declare c1 cursor for select * from h_db.emp_change;

   exec sql
      open transaction tx1 c1;

   while (1)
   {
       exec sql
          fetch c1 into :empno,:chg_type,:seqno;
       if ( (SQLCODE !=0) && (SQLCODE == 100) )
       {
          break;
       }
       else if (SQLCODE != 0)
       {
          printf("Error!  SQLCODE=%d\n",SQLCODE);
          break;
       }
       else
       {
           exec sql
              set transaction name tx2;
            
           if (strcmp("INS",chg_type) ==0)
           {
              exec sql
                 select transaction tx2 empname into :empname from h_db.employee where empno=:empno;
              exec sql
                 insert transaction tx2 into r_db.employee values (:empno,:empname);
           }
           else if (strcmp("UPD",chg_type) ==0)
           {
              exec sql
                 select transaction tx2 empname into :empname from h_db.employee where empno=:empno;
              exec sql
                 update transaction tx2 r_db.employee set empname = :empname where empno=:empno;
           }
           else
           {
              exec sql
                 delete transaction tx2 from  r_db.employee where empno=:empno;
           }
           if (SQLCODE == 0)
           {
               exec sql
                  delete transaction tx2 from h_db.emp_change where seqno=:seqno;
           }
           else
           {
              printf("Error with chg_type=%s,empno=%d,seqno=%d\n",chg_type,empno,seqno);
           }
           exec sql
              commit transaction tx2;
       }
       
   }
   exec sql
      close c1;
   exec sql
     commit transaction tx1;
   exec sql
     disconnect all;
}
