library safeudf;

uses
  SysUtils,
  Classes,
  ib_util; // ib_util can be found in interbase/include.

{  thread-safe UDF   " 
thread-safe UDF"   " "
http://www.ibase.ru.
 -  , support@ibase.ru (c) 1998-2003. }

{ examples of thread-safe UDFs.
http://www.ibase.ru
 Dmitri Kouzmenko, support@ibase.ru (c) 1998-2003. }


{ ,      .
    function3  function2. }
{ procedure, returning result via second input parameter.
This function works faster than function3 and function2 }

{ DECLARE EXTERNAL FUNCTION function1
   CSTRING(80), CSTRING(80)
   RETURNS PARAMETER 2
  ENTRY_POINT 'function1'  MODULE_NAME 'safeudf' }

procedure function1(P1, P2: PChar); cdecl; export;
 begin
  P2:=StrCopy(P2, P1);
 end;


{ ,    FREE_IT. ,
    ib_util_malloc - 
malloc       .
    function1  function3. }

{function, returning result as FREE_IT. 
This function works slower than function1 and function3 }

{ DECLARE EXTERNAL FUNCTION function2
   CSTRING(80)
   RETURNS CSTRING(80) FREE_IT
  ENTRY_POINT 'function2'  MODULE_NAME 'safeudf' }

function function2(P1: PChar): PChar; cdecl; export;
 var P2: PChar;
 begin
  P2:=ib_util_malloc(80);
  StrCopy(P2, P1);
  Result:=P2;
 end;


{ ,     .  
      .
     ,  IB 
 ,   ,   
    (     
    - ).
     function1,   function2. }

{function that do not allocates memory for result.
Memory, allocated for input parameter is used to return result.
There is no memory leaks in this case, because IB itself allocating
and deallocating memory for input parameters. ! That's why
both input parameters must be the same size.
This function works less slowly that function1, but faster than function2 }

{ DECLARE EXTERNAL FUNCTION function3
   CSTRING(80),
   RETURNS CSTRING(80)
  ENTRY_POINT 'function3'  MODULE_NAME 'safeudf' }

function function3(P1: PChar): PChar; cdecl; export;
 begin
  P1:=StrCopy(P1, P1);
  Result:=P1;
 end;

exports
 function1,
 function2,
 function3;

begin
 {     IB 4.2, 5.x  6.0  }
 { this is for multithreading. Needed to use udfs with IB 4.2, 5.x and 6.0}
 IsMultiThread:=True;
end.
