{
  TBUDF - Open Source UDF for InterBase and FireBird

  Authors...: Daniel Pereira Guimares and Anthony J. Caduto
  E-mail...: tecnobyte@ulbrajp.com.br; acaduto@amsoftwaredesign.com
  Tecno Byte Home-Page: www.ulbrajp.com.br/~tecnobyte
  AM Software design Home Page: http://www.amsoftwaredesign.com

  Null functions added on 3 July 2002 by Anthony J. Caduto
  Original Null functions by Claudio Valderama
  Special thanks to:
  Ann Harrison:  Provided varchar,cstring and text formats that are passed by descriptor
  Rudy Velthuis: Helped with buffer to string routines
  Henner Kollman: Ported the setnull and isnull functions
  And everyone else who helped from the Firebird-devel newsgroup 


  This library is Open-Source!
}

unit ibutil;

interface

uses
  sysutils, consts;

type

   TIBDate = integer;
   TIBTime = Cardinal;

   TIBTimeStamp= packed record
                    Date: TIBDate;
                    Time: TIBTime;
                 end;


   vvary = packed record
              vary_length: Word;
              vary_string: array[0..0] of Byte;
            end;

   stext = packed record
             s_string: array[0..0] of Byte;
            end;

   cstring = packed record
              s_string: array[0..0] of Byte;
              end;

   TDSC = packed record
           dsc_dtype,
           dsc_scale: byte;
           dsc_length,
           dsc_sub_type,
           dsc_flags: word;
           dsc_address: pointer;
         end;


   pvvary = ^vvary;
   pstext = ^stext;
   pcstring = ^cstring;
   PDSC = ^TDSC;
   PIBDate = ^TIBDate;
   PIBTime = ^TIBTime;
   PIBTimeStamp = ^TIBTimeStamp;
   ISC_byte= ^smallint;
   ISC_short= ^shortint;
   ISC_long= ^longint;
   ISC_int64 = ^int64;
   ISC_double = ^double;
   ISC_float = ^real;

procedure IBDecodeTime(IBTime: TIBTime; var Hour, Min, Sec: SmallInt);
function IBEncodeTime(Hour, Min, Sec: SmallInt): TIBTime;
procedure IBDecodeDate(IBDate: TIBDate; var Year, Month, Day: SmallInt);
function IBEncodeDate(Year, Month, Day: SmallInt): TIBDate;
function IBTimeSpan(T1, T2: TIBTimeStamp): int64;
function IBTimeAsSec(IBTime: TIBTime): integer;
function isNull(const Test: PDSC): boolean;
function setnull(v:PDSC):PDSC;
function get_int_value(v:PDSC):integer;
function get_double_value(v:PDSC):double;
function get_string_value(v:PDSC):string;
procedure copyparam(v,rc:PDSC);
function get_dayofweek(T: TIBTimeStamp):smallint;

implementation

function get_dayofweek(T: TIBTimeStamp):smallint;
  begin
       //code moved t function by Tony Caduto so it can be used by dow and sdow 7 July 2002
        result := (T.Date + 3) mod DAYS_PER_WEEK;
        if result < 0 then
           inc(result, DAYS_PER_WEEK);
        { Convert for [1..7] }
        Inc(result);
  end;

procedure copyparam( v,rc:PDSC);
  begin
       //code provided by Rudy Velthuis (TeamB)
       rc^ := v^;
       //GetMem(rc^.dsc_address, v^.dsc_length);
       Move(v^.dsc_address^, rc.dsc_address^, v^.dsc_length);
  end;

 function get_string_value(v:PDSC):string;
    var
       s:string;
       vartext:pvvary;
       thestext:pstext;
       cstring:pcstring;
     begin
         try
      	    case v^.dsc_dtype of
                 dtype_text:    begin
                                     //regular text
                                     //buffer to string by Rudy Velthuis (TeamB)
                                     thestext:= v^.dsc_address;
                                     SetLength(s, v^.dsc_length);
                                     FillChar(s[1], Length(s), #0);
                                     move(thestext^.s_string[0],s[1],length(s));
                                     result:=trim(s);
                                end;
	         dtype_cstring: begin
                                     //cstring
                                     cstring:= v^.dsc_address;
                                     SetLength(s, v^.dsc_length-1);
                                     FillChar(s[1], Length(s), #0);
                                     move(cstring^.s_string[0],s[1],length(s));
                                     result:=trim(s);
                                end;

	         dtype_varying: begin
                                    // Varchar
                                    vartext:=  v^.dsc_address;
                                    SetLength(s, vartext^.vary_length);
                                    FillChar(s[1], Length(s), #0);
                                    Move(vartext^.vary_string[0], S[1], vartext^.vary_length);
                                    result:= s;
                                end;
            end;//case
        except

        end;
    end;

 function get_double_value(v:PDSC):double;
 var
   //valfloat: ISC_float;
   valdouble: ISC_double;
   begin
        case v^.dsc_dtype of
        
         dtype_real:    begin
                             valdouble:= v.dsc_address;
                             result:=valdouble^;
                        end;

	 dtype_double:  begin
                             valdouble:=v.dsc_address;
                             result:=valdouble^;
                        end;

        end;//case
   end;
function get_int_value(v:PDSC):integer;
   var
   valshort: ISC_short;
   vallong:  ISC_long;
   val64:    ISC_int64;
   begin
      case v^.dsc_dtype of
        dtype_short:    begin
                             valshort:=v.dsc_address;
                             result:=valshort^;
                        end;

	 dtype_long:    begin
                            vallong:=v.dsc_address;
                             result:=vallong^;
                        end;

	dtype_int64:    begin
                             val64:=v.dsc_address;
                             result:=val64^;
                        end;
      end;//case

   end;


function isNull(const Test: PDSC): boolean;
//This routine ported by Henner Kollman
begin
  try
    if (Test = nil) or (Test^.dsc_address = nil) or ((Test^.dsc_flags and DSC_null) = DSC_null) then
      Result := true
    else
      Result := false;
  except
    result := false;
  end;
end;

function setnull(v:PDSC):PDSC;
  //This routine ported by Henner Kollman
  begin
       if assigned(v) then
	  v^.dsc_flags := v^.dsc_flags or DSC_null;
	  result:= v;
  end;

procedure IBDecodeTime(IBTime: TIBTime; var Hour, Min, Sec: SmallInt);
  { In InterBase: 1 second = 10000 }
var
  TotalSeconds: Cardinal;
begin
  TotalSeconds := IBTime div ISC_TIME_SECONDS_PRECISION;

  Hour := TotalSeconds div SECONDS_PER_HOUR;
  Min := (TotalSeconds div SECONDS_PER_MINUTE) mod SECONDS_PER_MINUTE;
  Sec := TotalSeconds mod SECONDS_PER_MINUTE;
end;

function IBEncodeTime(Hour, Min, Sec: SmallInt): TIBTime;
begin
  Result := (Hour * SECONDS_PER_HOUR + Min * SECONDS_PER_MINUTE + Sec)
    * ISC_TIME_SECONDS_PRECISION;
end;

procedure IBDecodeDate(IBDate: TIBDate; var Year, Month, Day: SmallInt);
  { The IBDecodeDate procedure is based in ndate() function of 
    gds.cpp (FireBird API) }
var
  Century, Y, M, D: integer;
begin
  IBDate := IBDate - (1721119 - 2400001);
  Century := (4 * IBDate - 1) div 146097;
  IBDate := 4 * IBDate - 1 - 146097 * Century;
  D := IBDate div 4;
  IBDate := (4 * D + 3) div 1461;
  D := 4 * D + 3 - 1461 * IBDate;
  D := (D + 4) div 4;
  M := (5 * D - 3) div 153;
  D := 5 * D - 3 - 153 * M;
  D := (D + 5) div 5;
  Y := 100 * Century + IBDate;

  if M < 10 then
    M := M + 3
  else begin
    M := M - 9;
    Y := Y + 1;
  end;

  Year := Y;
  Month := M;
  Day := D;
end;

function IBEncodeDate(Year, Month, Day: SmallInt): TIBDate;
  { The IBEncodeDate function is based in nday() function of
    gds.cpp (FireBird API) }
var
  Century, ShortYear: integer;
begin
  if Month > 2 then
    Month := Month - 3
  else begin
    Month := Month + 9;
    Year := Year - 1;
  end;

  Century := Year div 100;
  ShortYear := Year - 100 * Century;

  Result :=
    (146097 * Century) div 4 +
    (1461 * ShortYear) div 4 +
    (153 * Month + 2) div 5 + Day + 1721119 - 2400001;
end;

function IBTimeSpan(T1, T2: TIBTimeStamp): int64;
var
  Days, Seconds: integer;
begin
  if T1.Date < T2.Date then begin
    Days := T2.Date - T1.Date - 1;
    Seconds := SECONDS_PER_DAY - IBTimeAsSec(T1.Time) + IBTimeAsSec(T2.Time);
  end else if T1.Date > T2.Date then begin
    Days := T1.Date - T2.Date - 1;
    Seconds := SECONDS_PER_DAY - IBTimeAsSec(T1.Time) + IBTimeAsSec(T1.Time);
  end else begin { T1.Date = T2.Date }
    Days := 0;
    if T1.Time < T2.Time then
      Seconds := IBTimeAsSec(T2.Time) - IBTimeAsSec(T1.Time)
    else
      Seconds := IBTimeAsSec(T1.Time) - IBTimeAsSec(T2.Time);
  end;
  Result := int64(Days) * SECONDS_PER_DAY + int64(Seconds);
end;

function IBTimeAsSec(IBTime: TIBTime): integer;
begin
  Result := IBTime div ISC_TIME_SECONDS_PRECISION;
end;

end.
