{
  TBUDF - Open Source UDF for InterBase and FireBird

  Authors...: Daniel Pereira Guimares and Anthony J. Caduto
  E-mail...: tecnobyte@ulbrajp.com.br; acaduto@amsoftwaredesign.com
  Tecno Byte Home-Page: www.ulbrajp.com.br/~tecnobyte
  AM Software design Home Page: http://www.amsoftwaredesign.com

  Null and dow/sdow functions added on 3 July 2002 by Anthony J. Caduto
  Original Null functions by Claudio Valderama
  Special thanks to:
  Ann Harrison:  Provided varchar,cstring and text formats that are passed by descriptor
  Rudy Velthuis: Helped with buffer to string routines
  Henner Kollman: Ported the setnull and isnull functions
  And everyone else who helped from the Firebird-devel newsgroup 


  This library is Open-Source!
}
{$SOPREFIX ''} //removes the lib prefix when compiled with kylix
library tbudf;

uses
  SysUtils, Math,
  tbutil in 'tbutil.pas',
  ibutil in 'ibutil.pas',
  consts in 'consts.pas';

{ *** String functions *** }

function udf_Length(Str: PChar): integer; cdecl; export;
begin
  Result := StrLen(Str);
end;

function udf_Pos(Sub, Str: PChar): integer; cdecl; export;
begin
  Result := Pos(Sub, Str);
end;

function udf_Copy(Str: PChar; var Index, Count: integer): PChar; cdecl; export;
begin
  Result := Str;
  StrPCopy(Str, Copy(Str, Index, Count));
end;

function udf_Upper(Str: PChar): PChar; cdecl; export;
begin
  Result := Str;
  StrUpper(Str);
end;

function udf_Lower(Str: PChar): PChar; cdecl; export;
begin
  Result := Str;
  StrLower(Str);
end;

function udf_AnsiUpper(Str: PChar): PChar; cdecl; export;
begin
  Result := Str;
  AnsiStrUpper(Str);
end;

function udf_AnsiLower(Str: PChar): PChar; cdecl; export;
begin
  Result := Str;
  AnsiStrLower(Str);
end;

procedure udf_StrOfChar(Ret, Ch: PChar; var Count: integer); cdecl; export;
begin
  if (Ch = nil) or (Ch^ = #0) or (Count <= 0) then
    Ret^ := #0
  else
    StrPCopy(Ret, TBStrOfChar(Ch^, Count));
end;

procedure udf_Space(Ret: PChar; var Count: integer); cdecl; export;
begin
  if Count <= 0 then
    Ret^ := #0
  else
    StrPCopy(Ret, TBStrOfChar(#32, Count));
end;

function udf_Digits(Str: PChar): PChar; cdecl; export;
begin
  Result := Str;
  StrPCopy(Str, TBDigits(Str));
end;

function udf_Left(Str: PChar; var Count: integer): PChar; cdecl; export;
begin
  Result := Str;
  StrPCopy(Str, Copy(Str, 1, Count));
end;

function udf_Right(Str: PChar; var Count: integer): PChar; cdecl; export;
begin
  Result := Str;
  StrPCopy(Str, Copy(Str, Length(Str) - Count + 1, Count));
end;

function udf_LTrim(Str: PChar): PChar; cdecl; export;
begin
  Result := Str;
  StrPCopy(Str, TrimLeft(Str));
end;

function udf_RTrim(Str: PChar): PChar; cdecl; export;
begin
  Result := Str;
  StrPCopy(Str, TrimRight(Str));
end;

function udf_Trim(Str: PChar): PChar; cdecl; export;
begin
  Result := Str;
  StrPCopy(Str, Trim(Str));
end;

procedure udf_Chr(Ret: PChar; var Value: SmallInt); cdecl; export;
begin
  Ret[0] := Char(Value);
  Ret[1] := #0;
end;

function udf_Asc(Ch: PChar): SmallInt; cdecl; export;
begin
  if Ch = nil then
    Result := 0
  else
    Result := SmallInt(Ch[0]);
end;

function udf_CollateBr(Str: PChar): PChar; cdecl; export;
begin
  Result := Str;

  if Str = nil then
    Exit;

  while Str^ <> #0 do begin
    case Str^ of
      '', '', '', '', '', '',
      '', '', '', '', '', '': Str^ := 'A';

      '', '', '', '',
      '', '', '', '': Str^ := 'E';

      '', '', '', '',
      '', '', '', '': Str^ := 'I';

      '', '', '', '', '',
      '', '', '', '', '': Str^ := 'O';

      '', '', '', '',
      '', '', '', '': Str^ := 'U';

      '', '': Str^ := 'C';

      '', '': Str^ := 'N';

      '', '', '', '': Str^ := 'Y';
    else
      if Ord(Str^) > 127 then
        Str^ := #32;
    end;

    Inc(Str);
  end;
end;

procedure udf_IntToHex(Ret: PChar; var Value, Digits: integer); cdecl; export;
begin
  StrPCopy(Ret, IntToHex(Value, Digits));
end;

function udf_HexToInt(Str: PChar): integer; cdecl; export;
begin
  if Str = nil then
    Result := 0
  else if Str^ = '$' then
    Result := StrToIntDef(Str, 0)
  else
    Result := StrToIntDef('$' + Str, 0);
end;

{ *** Date/time functions *** }

//Day of week Functions added by Tony Caduto 7 July 2002
 function dow(var T: TIBTimeStamp;rc:pchar): pchar; cdecl; export;  //Long Name Day of Week
 var
   day:smallint;
   begin
        {When IBDate = 0, DayOfWeek = 3 (wednesday) --- [0..6] }
        day:= get_dayofweek(T);
        StrPCopy(rc, pchar(longdaynames[day]));  //longdaynames defined is sysutils
        result:=rc;
   end;

 function sdow(var T: TIBTimeStamp;rc:pchar): pchar; cdecl; export; //Short Name Day of Week
 var
   day:smallint;
   begin
        {When IBDate = 0, DayOfWeek = 3 (wednesday) --- [0..6] }
        day:= get_dayofweek(T);
        StrPCopy(rc, pchar(shortdaynames[day]));       //shortdaynames defined is sysutils
        result:=rc;
   end;

function udf_Day(var T: TIBTimeStamp): SmallInt; cdecl; export;
var
  Year, Month, Day: SmallInt;
begin
  IBDecodeDate(T.Date, Year, Month, Day);
  Result := Day;
end;

function udf_Month(var T: TIBTimeStamp): SmallInt; cdecl; export;
var
  Year, Month, Day: SmallInt;
begin
  IBDecodeDate(T.Date, Year, Month, Day);
  Result := Month;
end;

function udf_Year(var T: TIBTimeStamp): SmallInt; cdecl; export;
var
  Year, Month, Day: SmallInt;
begin
  IBDecodeDate(T.Date, Year, Month, Day);
  Result := Year;
end;

function udf_Hour(var T: TIBTimeStamp): SmallInt; cdecl; export;
var
  H, M, S: SmallInt;
begin
  IBDecodeTime(T.Time, H, M, S);
  Result := H;
end;

function udf_Minute(var T: TIBTimeStamp): SmallInt; cdecl; export;
var
  H, M, S: SmallInt;
begin
  IBDecodeTime(T.Time, H, M, S);
  Result := M;
end;

function udf_Second(var T: TIBTimeStamp): SmallInt; cdecl; export;
var
  H, M, S: SmallInt;
begin
  IBDecodeTime(T.Time, H, M, S);
  Result := S;
end;

procedure udf_EncodeDate(var Ret: TIBTimeStamp; var Year, Month, Day: SmallInt); cdecl; export;
begin
  Ret.Date := IBEncodeDate(Year, Month, Day);
  Ret.Time := 0;
end;

procedure udf_EncodeTime(var Ret: TIBTimeStamp; var H, M, S: SmallInt); cdecl; export;
begin
  Ret.Date := 0;
  Ret.Time := IBEncodeTime(H, M, S);
end;

procedure udf_EncodeTimeStamp(var Ret: TIBTimeStamp;
  var Year, Month, Day, Hour, Min, Sec: SmallInt); cdecl; export;
begin
  Ret.Date := IBEncodeDate(Year, Month, Day);
  Ret.Time := IBEncodeTime(Hour, Min, Sec);
end;

function udf_DaySpan(var T1, T2: TIBTimeStamp): double; cdecl; export;
var
  X, Y: double;
begin
  X := T1.Date + (T1.Time div ISC_TIME_SECONDS_PRECISION) / SECONDS_PER_DAY;
  Y := T2.Date + (T2 .Time div ISC_TIME_SECONDS_PRECISION) / SECONDS_PER_DAY;
  if X > Y then
    Result := X - Y
  else
    Result := Y - X;
end;

function udf_MonthSpan(var T1, T2: TIBTimeStamp): double; cdecl; export;
begin
  Result := udf_DaySpan(T1, T2) / APPROX_DAYS_PER_MONTH;
end;

function udf_YearSpan(var T1, T2: TIBTimeStamp): double; cdecl; export;
begin
  Result := udf_DaySpan(T1, T2) / APPROX_DAYS_PER_YEAR;
end;

function udf_WeekSpan(var T1, T2: TIBTimeStamp): double; cdecl; export;
begin
  Result := udf_DaySpan(T1, T2) / DAYS_PER_WEEK;
end;

function udf_SecondSpan(var T1, T2: TIBTimeStamp): double; cdecl; export;
begin
  Result := IBTimeSpan(T1, T2);
end;

function udf_MinuteSpan(var T1, T2: TIBTimeStamp): double; cdecl; export;
begin
  Result := IBTimeSpan(T1, T2) / SECONDS_PER_MINUTE;
end;

function udf_HourSpan(var T1, T2: TIBTimeStamp): double; cdecl; export;
begin
  Result := IBTimeSpan(T1, T2) / SECONDS_PER_HOUR;
end;

function udf_DaysBetween(var T1, T2: TIBTimeStamp): integer; cdecl; export;
begin
  Result := integer(Trunc(udf_DaySpan(T1, T2)));
end;

function udf_MonthsBetween(var T1, T2: TIBTimeStamp): integer; cdecl; export;
begin
  Result := integer(Trunc(udf_MonthSpan(T1, T2)));
end;

function udf_YearsBetween(var T1, T2: TIBTimeStamp): integer; cdecl; export;
begin
  Result := integer(Trunc(udf_YearSpan(T1, T2)));
end;

function udf_WeeksBetween(var T1, T2: TIBTimeStamp): integer; cdecl; export;
begin
  Result := integer(Trunc(udf_WeekSpan(T1, T2)));
end;

function udf_SecondsBetween(var T1, T2: TIBTimeStamp): int64; cdecl; export;
begin
  Result := IBTimeSpan(T1, T2);
end;

function udf_MinutesBetween(var T1, T2: TIBTimeStamp): int64; cdecl; export;
begin
  Result := IBTimeSpan(T1, T2) div SECONDS_PER_MINUTE;
end;

function udf_HoursBetween(var T1, T2: TIBTimeStamp): int64; cdecl; export;
begin
  Result := IBTimeSpan(T1, T2) div SECONDS_PER_HOUR;
end;

procedure udf_IncMonth(var Ret, T: TIBTimeStamp; var X: integer); cdecl; export;
var
  Y, M, D: SmallInt;
begin
  IBDecodeDate(T.Date, Y, M, D);
  TBIncMonth(Y, M, D, X);

  Ret.Date := IBEncodeDate(Y, M, D);
  Ret.Time := T.Time;
end;

procedure udf_IncYear(var Ret, T: TIBTimeStamp; var X: integer); cdecl; export;
var
  Y, M, D: SmallInt;
begin
  IBDecodeDate(T.Date, Y, M, D);
  TBIncYear(Y, M, D, X);

  Ret.Date := IBEncodeDate(Y, M, D);
  Ret.Time := T.Time;
end;

procedure udf_MonthStart(var Ret: TIBTimeStamp; var Year, Month: SmallInt); cdecl; export;
begin
  Ret.Date := IBEncodeDate(Year, Month, 1);
  Ret.Time := 0;
end;

procedure udf_MonthEnd(var Ret: TIBTimeStamp; var Year, Month: SmallInt); cdecl; export;
begin
  Ret.Date := IBEncodeDate(Year, Month, TBLastDay(Year, Month));
  Ret.Time := 0;
end;

function udf_LastDay(var Year, Month: SmallInt): SmallInt; cdecl; export;
begin
  Result := TBLastDay(Year, Month);
end;

function udf_DayFrac(var T: TIBTimeStamp): double; cdecl; export;
var
  H, M, S: SmallInt;
begin
  IBDecodeTime(T.Time, H, M, S);
  Result := (H * SECONDS_PER_HOUR + M * SECONDS_PER_MINUTE + S)
    / SECONDS_PER_DAY;
end;

function udf_DayOfWeek(var T: TIBTimeStamp): SmallInt; cdecl; export;
begin

  Result := get_dayofweek(T);

end;

function udf_DayOfYear(var T: TIBTimeStamp): SmallInt; cdecl; export;
var
  Year, Month, Day, I: SmallInt;
begin
  IBDecodeDate(T.Date, Year, Month, Day);

  Result := Day;

  for I := 1 to (Month - 1) do
    Inc(Result, MONTH_DAYS[I]);

  if (Month > 2) and IsLeapYear(Year) then
    Inc(Result);
end;

{ *** Math functions *** }

function udf_Double(var X: double): double; cdecl; export;
begin
  Result := X;
end;

function udf_Frac(var X: double): double; cdecl; export;
begin
  Result := Frac(X);
end;

function udf_Int(var X: double): double; cdecl; export;
begin
  Result := Int(X);
end;

function udf_Trunc(var X: double): integer; cdecl; export;
begin
  Result := integer(Trunc(X));
end;

function udf_TruncDec(var X: double; var Decimal: SmallInt): double; cdecl; export;
var
  Y: integer;
begin
  if Decimal <= 0 then
    Result := Trunc(X)
  else begin
    Y := TBPosValue(1, 10, Decimal + 1);
    Result := integer(Trunc(X * Y)) / Y;
  end;
end;

function udf_Ceil(var X: double): integer; cdecl; export;
begin
  Result := Ceil(X);
end;

function udf_Floor(var X: double): integer; cdecl; export;
begin
  Result := Floor(X);
end;

function udf_Max(var A, B: double): double; cdecl; export;
begin
  if A > B then
    Result := A
  else
    Result := B;
end;

function udf_Min(var A, B: double): double; cdecl; export;
begin
  if A < B then
    Result := A
  else
    Result := B;
end;

function udf_Abs(var X: double): double; cdecl; export;
begin
  if X < 0 then
    Result := -X
  else
    Result := X;
end;

function udf_Div(var Dividend, Divisor: integer): integer; cdecl; export;
begin
  Result := Dividend div Divisor;
end;

function udf_Mod(var Dividend, Divisor: integer): integer; cdecl; export;
begin
  Result := Dividend mod Divisor;
end;

function udf_Exp(var X: double): double; cdecl; export;
begin
  Result := Exp(X);
end;

function udf_Factorial(var N: integer): integer; cdecl; export;
var
  I: integer;
begin
  if N < 0 then
    Result := 0
  else if N = 0 then
    Result := 1
  else begin
    Result := N;
    I := N - 1;
    while I > 1 do begin
      Result := Result * I;
      Dec(I);
    end;
  end;
end;

function udf_Sqrt(var X: double): double; cdecl; export;
begin
  Result := Sqrt(X);
end;

function udf_Power(var Base, Exponent: double): double; cdecl; export;
begin
  Result := Power(Base, Exponent);
end;

function udf_LnXP1(var X: double): double; cdecl; export;
begin
  Result := LnXP1(X);
end;

function udf_Log10(var X: double): double; cdecl; export;
begin
  Result := Log10(X);
end;

function udf_Log2(var X: double): double; cdecl; export;
begin
  Result := Log2(X);
end;

function udf_LogN(var Base, X: double): double; cdecl; export;
begin
  Result := LogN(Base, X);
end;

{ *** Trigonometric functions *** }

function udf_Pi: double; cdecl; export;
begin
  Result := Pi;
end;

function udf_DegToRad(var x: double): double; cdecl; export;
begin
  Result := x * (Pi / 180);
end;

function udf_RadToDeg(var x: double): double; cdecl; export;
begin
  Result := x * (180 / Pi);
end;

function udf_Cos(var x: double): double; cdecl; export;
begin
  Result := Cos(x);
end;

function udf_Sin(var x: double): double; cdecl; export;
begin
  Result := Sin(x);
end;

function udf_Tan(var x: double): double; cdecl; export;
begin
  try
    Result := Sin(x) / Cos(x);
  except
    Result := 0;
  end;
end;

function udf_CoTan(var x: double): double; cdecl; export;
begin
  try
    Result := Cos(x) / Sin(x);
  except
    Result := 0;
  end;
end;

function udf_Hypot(var x, y: double): double; cdecl; export;
begin
  Result := Sqrt(x * x + y * y);
end;

{ *** Bit functions *** }

function udf_Not(var X: integer): integer; cdecl; export;
begin
  Result := not X;
end;

function udf_And(var X, Y: integer): integer; cdecl; export;
begin
  Result := X and Y;
end;

function udf_Or(var X, Y: integer): integer; cdecl; export;
begin
  Result := X or Y;
end;

function udf_Xor(var X, Y: integer): integer; cdecl; export;
begin
  Result := X xor Y;
end;

function udf_ShL(var X, Y: integer): integer; cdecl; export;
begin
  Result := X shl Y;
end;

function udf_ShR(var X, Y: integer): integer; cdecl; export;
begin
  Result := X shr Y;
end;

{ *** Null functions *** }
// Null functions added by Tony Caduto, 3 July 2002
// Note, these will only work with Firebird because they
// pass values by descriptor.

function idNvl( v,v2:PDSC):PDSC;cdecl; export;
begin

	if not isnull(v) then
		result:= v else
	result:= v2;
end;

function sNvl(v,v2,rc:PDSC):PDSC;cdecl;export;
  begin
       if not isnull(v) then
           begin
               try
                  copyparam(v,rc);
                  result:=rc;
               except
                  //do nothing right now
               end;
           end else
                if not isnull(v2) then
                   begin
                       try
                          copyparam(v2,rc);
                          result:=rc;
                       except
                       //do nothing right now
                      end;
                   end else
                          result:=setnull(rc);
  end;

 function iNullIf( v,v2:PDSC):PDSC;cdecl; export;
 var
   val1,val2:integer;
    begin
         val1:=get_int_value(v);
         val2:=get_int_value(v2);
         if isnull(v) or isnull(v2) then
            result:=nil else
              if val1 = val2  then
                 result:= nil else
                            result:= v;
    end;

function dNullIf( v,v2:PDSC):PDSC;cdecl; export;
var
val1,val2:double;

   begin
       val1:=get_double_value(v);
       val2:=get_double_value(v2);
       if isnull(v) or isnull(v2) then
          result:=nil else
           if val1 = val2  then
              result:= nil else
                    result:= v;
   end;

function sNullIf(v,v2,rc:PDSC):PDSC;cdecl;export;
var
 val1,val2:string;
     begin
           if isnull(v) or isnull(v2) then
               result:=setnull(rc) else
                begin
                    val1:= get_string_value(v);
                    val2:= get_string_value(v2);
                    if val1 = val2 then
                       result:=setnull(rc) else
                       begin //copy v to rc
                           copyparam(v,rc);
                           result:=rc;
                       end;
                end;
     end;




exports
  idNvl,
  sNvl,
  iNullIf,
  dNullIf,
  sNullIf,
  udf_Length,
  udf_Pos,
  udf_Copy,
  udf_Upper,
  udf_Lower,
  udf_AnsiUpper,
  udf_AnsiLower,
  udf_StrOfChar,
  udf_Space,
  udf_Digits,
  udf_Left,
  udf_Right,
  udf_LTrim,
  udf_RTrim,
  udf_Trim,
  udf_Chr,
  udf_Asc,
  udf_CollateBr,
  udf_IntToHex,
  udf_HexToInt,

  dow,
  sdow,
  udf_Day,
  udf_Month,
  udf_Year,
  udf_Hour,
  udf_Minute,
  udf_Second,
  udf_EncodeDate,
  udf_EncodeTime,
  udf_EncodeTimeStamp,
  udf_DaySpan,
  udf_MonthSpan,
  udf_YearSpan,
  udf_WeekSpan,
  udf_SecondSpan,
  udf_MinuteSpan,
  udf_HourSpan,
  udf_DaysBetween,
  udf_MonthsBetween,
  udf_YearsBetween,
  udf_WeeksBetween,
  udf_SecondsBetween,
  udf_MinutesBetween,
  udf_HoursBetween,
  udf_IncMonth,
  udf_IncYear,
  udf_MonthStart,
  udf_MonthEnd,
  udf_LastDay,
  udf_DayFrac,
  udf_DayOfWeek,
  udf_DayOfYear,

  udf_Double,
  udf_Frac,
  udf_Int,
  udf_Trunc,
  udf_TruncDec,
  udf_Ceil,
  udf_Floor,
  udf_Max,
  udf_Min,
  udf_Abs,
  udf_Div,
  udf_Mod,
  udf_Exp,
  udf_Factorial,
  udf_Sqrt,
  udf_Power,
  udf_LnXP1,
  udf_Log10,
  udf_Log2,
  udf_LogN,

  udf_Pi,
  udf_DegToRad,
  udf_RadToDeg,
  udf_Cos,
  udf_Sin,
  udf_Tan,
  udf_CoTan,
  udf_Hypot,

  udf_Not,
  udf_And,
  udf_Or,
  udf_Xor,
  udf_ShL, 
  udf_ShR;

begin
end.
