/*
  TBUDF - Open Source UDF for InterBase and FireBird

  Authors...: Daniel Pereira Guimares and Anthony J. Caduto
  E-mail...: tecnobyte@ulbrajp.com.br; acaduto@amsoftwaredesign.com
  Tecno Byte Home-Page: www.ulbrajp.com.br/~tecnobyte
  AM Software design Home Page: http://www.amsoftwaredesign.com

  Null functions added on 3 July 2002 by Anthony J. Caduto
  Special thanks to:
  Ann Harrison:  Provided varchar,cstring and text formats that are passed by descriptor
  Rudy Velthuis: Helped with buffer to string routines
  Henner Kollman: Ported the setnull and isnull functions
  And everyone else who helped from the Firebird-devel newsgroup

  This library is Open-Source!
*/

/*  Start null functions  NOTE these will only work on Firebird 1.0 because they pass params by descriptor */
declare external function invl
int by descriptor, int by descriptor
returns int by descriptor
entry_point 'idNvl' module_name 'tbudf';


declare external function i64nvl
numeric(18,0) by descriptor, numeric(18,0) by descriptor
returns numeric(18,0) by descriptor
entry_point 'idNvl' module_name 'tbudf';


declare external function dnvl
double precision by descriptor, double precision by descriptor
returns double precision by descriptor
entry_point 'idNvl' module_name 'tbudf';


declare external function snvl
varchar(100) by descriptor, varchar(100) by descriptor,
varchar(100) by descriptor returns parameter 3
entry_point 'sNvl' module_name 'tbudf';


declare external function inullif
int by descriptor, int by descriptor
returns int by descriptor
entry_point 'iNullIf' module_name 'tbudf';


declare external function dnullif
double precision by descriptor, double precision by descriptor
returns double precision by descriptor
entry_point 'dNullIf' module_name 'tbudf';


declare external function i64nullif
numeric(18,4) by descriptor, numeric(18,4) by descriptor
returns numeric(18,4) by descriptor
entry_point 'iNullIf' module_name 'tbudf';


declare external function snullif
varchar(100) by descriptor, varchar(100) by descriptor,
varchar(100) by descriptor returns parameter 3
entry_point 'sNullIf' module_name 'tbudf';

/* End null functions   */

declare external function udf_Length
cstring(254) 
returns integer by value
entry_point 'udf_Length' module_name 'tbudf';

declare external function udf_Pos
cstring(254), cstring(254)
returns integer by value
entry_point 'udf_Pos' module_name 'tbudf';

declare external function udf_Copy
cstring(254), integer, integer
returns cstring(254)
entry_point 'udf_Copy' module_name 'tbudf';

declare external function udf_Upper
cstring(254)
returns cstring(254)
entry_point 'udf_Upper' module_name 'tbudf';

declare external function udf_Lower
cstring(254)
returns cstring(254)
entry_point 'udf_Lower' module_name 'tbudf';

declare external function udf_AnsiUpper
cstring(254)
returns cstring(254)
entry_point 'udf_AnsiUpper' module_name 'tbudf';

declare external function udf_AnsiLower
cstring(254)
returns cstring(254)
entry_point 'udf_AnsiLower' module_name 'tbudf';

declare external function udf_StrOfChar
cstring(254), cstring(1), integer
returns parameter 1
entry_point 'udf_StrOfChar' module_name 'tbudf';

declare external function udf_Space
cstring(254), integer
returns parameter 1
entry_point 'udf_Space' module_name 'tbudf';

declare external function udf_Digits
cstring(254)
returns cstring(254)
entry_point 'udf_Digits' module_name 'tbudf';

declare external function udf_Left
cstring(254), integer
returns cstring(254)
entry_point 'udf_Left' module_name 'tbudf';

declare external function udf_Right
cstring(254), integer
returns cstring(254)
entry_point 'udf_Right' module_name 'tbudf';

declare external function udf_LTrim
cstring(254)
returns cstring(254)
entry_point 'udf_LTrim' module_name 'tbudf';

declare external function udf_RTrim
cstring(254)
returns cstring(254)
entry_point 'udf_RTrim' module_name 'tbudf';

declare external function udf_Trim
cstring(254)
returns cstring(254)
entry_point 'udf_Trim' module_name 'tbudf';

declare external function udf_Chr
cstring(1), smallint
returns parameter 1
entry_point 'udf_Chr' module_name 'tbudf';

declare external function udf_Asc
cstring(254)
returns smallint by value
entry_point 'udf_Asc' module_name 'tbudf';

declare external function udf_CollateBr
cstring(254)
returns cstring(254)
entry_point 'udf_CollateBr' module_name 'tbudf';

declare external function udf_IntToHex
cstring(20), integer, integer
returns parameter 1
entry_point 'udf_IntToHex' module_name 'tbudf';

declare external function udf_HexToInt
cstring(20)
returns integer by value
entry_point 'udf_HexToInt' module_name 'tbudf';

declare external function dow
timestamp,
cstring(15) returns parameter 2
entry_point 'dow' module_name 'tbudf';

declare external function sdow
timestamp,
cstring(5) returns parameter 2
entry_point 'sdow' module_name 'tbudf';

declare external function udf_Day
timestamp
returns smallint by value
entry_point 'udf_Day' module_name 'tbudf';

declare external function udf_Month
timestamp
returns smallint by value
entry_point 'udf_Month' module_name 'tbudf';

declare external function udf_Year
timestamp
returns smallint by value
entry_point 'udf_Year' module_name 'tbudf';

declare external function udf_Hour
timestamp
returns smallint by value
entry_point 'udf_Hour' module_name 'tbudf';

declare external function udf_Minute
timestamp
returns smallint by value
entry_point 'udf_Minute' module_name 'tbudf';

declare external function udf_Second
timestamp
returns smallint by value
entry_point 'udf_Second' module_name 'tbudf';

declare external function udf_EncodeDate
timestamp, smallint, smallint, smallint
returns parameter 1
entry_point 'udf_EncodeDate' module_name 'tbudf';

declare external function udf_EncodeTime
timestamp, smallint, smallint, smallint
returns parameter 1
entry_point 'udf_EncodeTime' module_name 'tbudf';

declare external function udf_EncodeTimeStamp
timestamp, smallint, smallint, smallint, smallint, smallint, smallint
returns parameter 1
entry_point 'udf_EncodeTimeStamp' module_name 'tbudf';

declare external function udf_DaySpan
timestamp, timestamp
returns double precision by value
entry_point 'udf_DaySpan' module_name 'tbudf';

declare external function udf_MonthSpan
timestamp, timestamp
returns double precision by value
entry_point 'udf_MonthSpan' module_name 'tbudf';

declare external function udf_YearSpan
timestamp, timestamp
returns double precision by value
entry_point 'udf_YearSpan' module_name 'tbudf';

declare external function udf_WeekSpan
timestamp, timestamp
returns double precision by value
entry_point 'udf_WeekSpan' module_name 'tbudf';

declare external function udf_SecondSpan
timestamp, timestamp
returns double precision by value
entry_point 'udf_SecondSpan' module_name 'tbudf';

declare external function udf_MinuteSpan
timestamp, timestamp
returns double precision by value
entry_point 'udf_MinuteSpan' module_name 'tbudf';

declare external function udf_HourSpan
timestamp, timestamp
returns double precision by value
entry_point 'udf_HourSpan' module_name 'tbudf';

declare external function udf_DaysBetween
timestamp, timestamp
returns integer by value
entry_point 'udf_DaysBetween' module_name 'tbudf';

declare external function udf_MonthsBetween
timestamp, timestamp
returns integer by value
entry_point 'udf_MonthsBetween' module_name 'tbudf';

declare external function udf_YearsBetween
timestamp, timestamp
returns integer by value
entry_point 'udf_YearsBetween' module_name 'tbudf';

declare external function udf_WeeksBetween
timestamp, timestamp
returns integer by value
entry_point 'udf_WeeksBetween' module_name 'tbudf';

declare external function udf_SecondsBetween
timestamp, timestamp
returns numeric(18,0) by value
entry_point 'udf_SecondsBetween' module_name 'tbudf';

declare external function udf_MinutesBetween
timestamp, timestamp
returns numeric(18,0) by value
entry_point 'udf_MinutesBetween' module_name 'tbudf';

declare external function udf_HoursBetween
timestamp, timestamp
returns numeric(18,0) by value
entry_point 'udf_HoursBetween' module_name 'tbudf';

declare external function udf_IncMonth
timestamp, timestamp, integer
returns parameter 1
entry_point 'udf_IncMonth' module_name 'tbudf';

declare external function udf_IncYear
timestamp, timestamp, integer
returns parameter 1
entry_point 'udf_IncYear' module_name 'tbudf';

declare external function udf_MonthStart
timestamp, smallint, smallint
returns parameter 1
entry_point 'udf_MonthStart' module_name 'tbudf';

declare external function udf_MonthEnd
timestamp, smallint, smallint
returns parameter 1
entry_point 'udf_MonthEnd' module_name 'tbudf';

declare external function udf_LastDay
smallint, smallint
returns smallint by value
entry_point 'udf_LastDay' module_name 'tbudf';

declare external function udf_DayFrac
timestamp
returns double precision by value
entry_point 'udf_DayFrac' module_name 'tbudf';

declare external function udf_DayOfWeek
timestamp
returns smallint by value
entry_point 'udf_DayOfWeek' module_name 'tbudf';

declare external function udf_DayOfYear
timestamp
returns smallint by value
entry_point 'udf_DayOfYear' module_name 'tbudf';

declare external function udf_Double
double precision
returns double precision by value
entry_point 'udf_Double' module_name 'tbudf';

declare external function udf_Frac
double precision
returns double precision by value
entry_point 'udf_Frac' module_name 'tbudf';

declare external function udf_Int
double precision
returns double precision by value
entry_point 'udf_Int' module_name 'tbudf';

declare external function udf_Trunc
double precision
returns integer by value
entry_point 'udf_Trunc' module_name 'tbudf';

declare external function udf_TruncDec
double precision, smallint
returns double precision by value
entry_point 'udf_TruncDec' module_name 'tbudf';

declare external function udf_Ceil
double precision
returns integer by value
entry_point 'udf_Ceil' module_name 'tbudf';

declare external function udf_Floor
double precision
returns integer by value
entry_point 'udf_Floor' module_name 'tbudf';

declare external function udf_Max
double precision, double precision
returns double precision by value
entry_point 'udf_Max' module_name 'tbudf';

declare external function udf_Min
double precision, double precision
returns double precision by value
entry_point 'udf_Min' module_name 'tbudf';

declare external function udf_Abs
double precision
returns double precision by value
entry_point 'udf_Abs' module_name 'tbudf';

declare external function udf_Div
integer, integer
returns integer by value
entry_point 'udf_Div' module_name 'tbudf';

declare external function udf_Mod
integer, integer
returns integer by value
entry_point 'udf_Mod' module_name 'tbudf';

declare external function udf_Exp
double precision
returns double precision by value
entry_point 'udf_Exp' module_name 'tbudf';

declare external function udf_Factorial
integer
returns integer by value
entry_point 'udf_Factorial' module_name 'tbudf';

declare external function udf_Sqrt
double precision
returns double precision by value
entry_point 'udf_Sqrt' module_name 'tbudf';

declare external function udf_Power
double precision, double precision
returns double precision by value
entry_point 'udf_Power' module_name 'tbudf';

declare external function udf_LnXP1
double precision
returns double precision by value
entry_point 'udf_LnXP1' module_name 'tbudf';

declare external function udf_Log10
double precision
returns double precision by value
entry_point 'udf_Log10' module_name 'tbudf';

declare external function udf_Log2
double precision
returns double precision by value
entry_point 'udf_Log2' module_name 'tbudf';

declare external function udf_LogN
double precision, double precision
returns double precision by value
entry_point 'udf_LogN' module_name 'tbudf';

declare external function udf_Pi
returns double precision by value
entry_point 'udf_Pi' module_name 'tbudf';

declare external function udf_DegToRad
double precision
returns double precision by value
entry_point 'udf_DegToRad' module_name 'tbudf';

declare external function udf_RadToDeg
double precision
returns double precision by value
entry_point 'udf_RadToDeg' module_name 'tbudf';

declare external function udf_Cos
double precision
returns double precision by value
entry_point 'udf_Cos' module_name 'tbudf';

declare external function udf_Sin
double precision
returns double precision by value
entry_point 'udf_Sin' module_name 'tbudf';

declare external function udf_Tan
double precision
returns double precision by value
entry_point 'udf_Tan' module_name 'tbudf';

declare external function udf_CoTan
double precision
returns double precision by value
entry_point 'udf_CoTan' module_name 'tbudf';

declare external function udf_Hypot
double precision, double precision
returns double precision by value
entry_point 'udf_Hypot' module_name 'tbudf';

/*------------------------------------------------------------------*/

declare external function udf_Not
integer
returns integer by value
entry_point 'udf_Not' module_name 'tbudf';

declare external function udf_And
integer, integer
returns integer by value
entry_point 'udf_And' module_name 'tbudf';

declare external function udf_Or
integer, integer
returns integer by value
entry_point 'udf_Or' module_name 'tbudf';

declare external function udf_Xor
integer, integer
returns integer by value
entry_point 'udf_Xor' module_name 'tbudf';

declare external function udf_ShL
integer, integer
returns integer by value
entry_point 'udf_ShL' module_name 'tbudf';

declare external function udf_ShR
integer, integer
returns integer by value
entry_point 'udf_ShR' module_name 'tbudf';
