{
  TBUDF - Open Source UDF for InterBase and FireBird

  Authors...: Daniel Pereira Guimares and Anthony J. Caduto
  E-mail...: tecnobyte@ulbrajp.com.br; acaduto@amsoftwaredesign.com
  Tecno Byte Home-Page: www.ulbrajp.com.br/~tecnobyte
  AM Software design Home Page: http://www.amsoftwaredesign.com

  Null functions added on 3 July 2002 by Anthony J. Caduto
  Original Null functions by Claudio Valderama
  Special thanks to:
  Ann Harrison:  Provided varchar,cstring and text formats that are passed by descriptor
  Rudy Velthuis: Helped with buffer to string routines
  Henner Kollman: Ported the setnull and isnull functions
  And everyone else who helped from the Firebird-devel newsgroup 


  This library is Open-Source!
}

unit tbutil;

interface

uses
  SysUtils, consts;

function TBStrOfChar(const Ch: Char; const Count: integer): string;
function TBDigits(const S: string): string;

function TBLastDay(const Year, Month: SmallInt): SmallInt;
procedure TBIncMonth(var Y, M, D: SmallInt; const X: integer);
procedure TBIncYear(var Y, M, D: SmallInt; const X: integer);

function TBPosValue(const AbsValue, Base, Position: byte): integer;

implementation

function TBStrOfChar(const Ch: Char; const Count: integer): string;
var
  I: integer;
begin
  if Count <= 0 then
    Result := ''
  else begin
    SetLength(Result, Count);
    for I := 1 to Count do
      Result[I] := Ch;
  end;
end;

function TBDigits(const S: string): string;
var
  I: integer;
begin
  Result := '';
  for I := 1 to Length(S) do
    if S[I] in ['0'..'9'] then
      Result := Result + S[I];
end;

function TBLastDay(const Year, Month: SmallInt): SmallInt;
begin
  if (Month = 2) and IsLeapYear(Year) then
    Result := 29
  else
    Result := MONTH_DAYS[Month];
end;

procedure TBIncMonth(var Y, M, D: SmallInt; const X: integer);
begin
  Inc(Y, X div MONTHS_PER_YEAR);
  Inc(M, X mod MONTHS_PER_YEAR);
  if M > MONTHS_PER_YEAR then begin
    M := M - MONTHS_PER_YEAR;
    Inc(Y);
  end else if M < 1 then begin
    M := M + MONTHS_PER_YEAR;
    Dec(Y);
  end;

  if (M = 2) and (D > 28) then begin
    if IsLeapYear(Y) then
      D := 29
    else
      D := 28;
  end else if (D > MONTH_DAYS[M]) then
    D := MONTH_DAYS[M];
end;

procedure TBIncYear(var Y, M, D: SmallInt; const X: integer);
begin
  Inc(Y, X);
  if (M = 2) and (D > 28) then begin
    if IsLeapYear(Y) then
      D := 29
    else
      D := 28;
  end;
end;

function TBPosValue(const AbsValue, Base, Position: byte): integer;
var
  X: integer;
  I: byte;
begin
  if Position = 0 then
    Result := AbsValue
  else begin
    X := Base;
    for I := 2 to Position do
      X := X * Base;

    Result := X * AbsValue;
  end;
end;

end.
