/******************************************************************************/
/***                         User Defined Functions                         ***/
/******************************************************************************/

DECLARE EXTERNAL FUNCTION BLOBINFO
    BLOB,
    CSTRING(255)
    RETURNS PARAMETER 2
    ENTRY_POINT 'BLObInfo' MODULE_NAME 'JHBlobUDF';


DECLARE EXTERNAL FUNCTION BLOBSEARCHSUBSTR
    BLOB,
    CSTRING(255)
    RETURNS INTEGER BY VALUE
    ENTRY_POINT 'BLObSearch' MODULE_NAME 'JHBlobUDF';


DECLARE EXTERNAL FUNCTION BLOBTOSTR
    BLOB,
    CSTRING(16384)
    RETURNS PARAMETER 2
    ENTRY_POINT 'BLObToCString' MODULE_NAME 'JHBlobUDF';


DECLARE EXTERNAL FUNCTION COMPRESSBLOB
    BLOB,
    BLOB
    RETURNS PARAMETER 2
    ENTRY_POINT 'CompressBLOB' MODULE_NAME 'JHBlobUDF';


DECLARE EXTERNAL FUNCTION DECOMPRESSBLOB
    BLOB,
    BLOB
    RETURNS PARAMETER 2
    ENTRY_POINT 'DeCompressBLOB' MODULE_NAME 'JHBlobUDF';

DECLARE EXTERNAL FUNCTION ISCOMPRESSED
    BLOB
    RETURNS INTEGER BY VALUE
    ENTRY_POINT 'IsCompressed' MODULE_NAME 'JHBlobUDF';


DECLARE EXTERNAL FUNCTION JHPRSCREATE

    RETURNS INTEGER BY VALUE
    ENTRY_POINT 'JHPrsCreate' MODULE_NAME 'JHBlobUDF';


DECLARE EXTERNAL FUNCTION JHPRSEOF
    INTEGER
    RETURNS INTEGER BY VALUE
    ENTRY_POINT 'JHPrsEOF' MODULE_NAME 'JHBlobUDF';


DECLARE EXTERNAL FUNCTION JHPRSFREE
    INTEGER
    RETURNS INTEGER BY VALUE
    ENTRY_POINT 'JHPrsFree' MODULE_NAME 'JHBlobUDF';


DECLARE EXTERNAL FUNCTION JHPRSNEXTWORD
    INTEGER,
    CSTRING(50)
    RETURNS PARAMETER 2
    ENTRY_POINT 'JHPrsNextWord' MODULE_NAME 'JHBlobUDF';


DECLARE EXTERNAL FUNCTION JHPRSPASRSE
    INTEGER,
    BLOB
    RETURNS INTEGER BY VALUE
    ENTRY_POINT 'JHPrsPasrse' MODULE_NAME 'JHBlobUDF';


DECLARE EXTERNAL FUNCTION JHPRSRESET
    INTEGER
    RETURNS INTEGER BY VALUE
    ENTRY_POINT 'JHPrsReset' MODULE_NAME 'JHBlobUDF';


DECLARE EXTERNAL FUNCTION STRTOBLOB
    CSTRING(16384),
    BLOB
    RETURNS PARAMETER 2
    ENTRY_POINT 'CStringToBLOb' MODULE_NAME 'JHBlobUDF';




/******************************************************************************/
/***                               Generators                               ***/
/******************************************************************************/

CREATE GENERATOR GEN_JHPRS_WORDS_ID;
SET GENERATOR GEN_JHPRS_WORDS_ID TO 129504;



SET TERM ^ ; 



/******************************************************************************/
/***                           Stored Procedures                            ***/
/******************************************************************************/

CREATE PROCEDURE JHPRS_PARSE_DOC (
    DOC_ID INTEGER)
AS
BEGIN
  EXIT;
END^


CREATE PROCEDURE TEST_PARSE_DOCS (
    START_R INTEGER,
    END_R INTEGER)
AS
BEGIN
  EXIT;
END^



SET TERM ; ^


/******************************************************************************/
/***                                 Tables                                 ***/
/******************************************************************************/

CREATE TABLE JHPRS_LINKS (
    ID      INTEGER NOT NULL,
    OBJ_ID  INTEGER NOT NULL
);

CREATE TABLE JHPRS_WORDS (
    ID   INTEGER NOT NULL,
    WRD  VARCHAR(50) NOT NULL COLLATE PXW_CYRL
);





/******************************************************************************/
/***                           Unique Constraints                           ***/
/******************************************************************************/

ALTER TABLE JHPRS_WORDS ADD CONSTRAINT UNQ_JHPRS_WORDS UNIQUE (WRD);


/******************************************************************************/
/***                              Primary Keys                              ***/
/******************************************************************************/

ALTER TABLE JHPRS_LINKS ADD CONSTRAINT PK_JHPRS_LINKS PRIMARY KEY (ID, OBJ_ID);
ALTER TABLE JHPRS_WORDS ADD CONSTRAINT PK_JHPRS_WORDS PRIMARY KEY (ID);



/******************************************************************************/
/***                                Triggers                                ***/
/******************************************************************************/


SET TERM ^ ;




/* Trigger: JHPRS_WORDS_BI */
CREATE TRIGGER JHPRS_WORDS_BI FOR JHPRS_WORDS
ACTIVE BEFORE INSERT POSITION 0
AS
BEGIN
  IF (NEW.ID IS NULL) THEN
    NEW.ID = GEN_ID(GEN_JHPRS_WORDS_ID,1);
END
^

SET TERM ; ^



/******************************************************************************/
/***                           Stored Procedures                            ***/
/******************************************************************************/


SET TERM ^ ;

ALTER PROCEDURE JHPRS_PARSE_DOC (
    DOC_ID INTEGER)
AS
DECLARE VARIABLE I INTEGER;
DECLARE VARIABLE K INTEGER;
DECLARE VARIABLE ST VARCHAR(50);
DECLARE VARIABLE ID INTEGER;
DECLARE VARIABLE BL BLOB;
begin
  select html from docs where doc_id = :doc_id into :bl;
  if (bl is null) then exit;
  i = jhprscreate();
  if (i < 0) then exit;
  k = jhprspasrse(i, bl);
  while (jhprseof(i) = 0) do
   begin
    st = jhprsnextword(i);
    id = null;
    select id from jhprs_words where wrd = :st into :id;
    if (id is null) then
     begin
      id = gen_id(gen_jhprs_words_id, 1);
      insert into jhprs_words(id, wrd) values (:id, :st);
     end
    if (not exists (select 0 from jhprs_links l where id = :id and obj_id = :doc_id)) then
     insert into jhprs_links(id, obj_id) values (:id, :doc_id);
   end
  k = jhprsfree(i);
end
^

ALTER PROCEDURE TEST_PARSE_DOCS (
    START_R INTEGER,
    END_R INTEGER)
AS
DECLARE VARIABLE DOC_ID INTEGER;
begin
  for select doc_id
   from docs
   where
   doc_id between :start_r and :end_r
  into
   :doc_id
  do
   execute procedure jhprs_parse_doc(:doc_id);
end
^


SET TERM ; ^
