{$ALIGN OFF}

unit Common;

interface

uses SysUtils, Classes, ZLIBEX;

type
  // C, C++     Delphi          InterBase
  Short = SmallInt; // SmallInt
  Long = Longint; // Integer
  // int    = Integer;     // Integer
  Float = Single; // Float
  // Double = Double;      // Double
  // *void, *char = PChar; // Char(???), VarChar(???), CString

  PSmallInt = ^SmallInt;
  PInteger = ^Integer;
  PShort = ^Short;
  PLong = ^Long;
  PFloat = ^Float;
  PDouble = ^Double;

  TBLOb = record
    GetSegment: function(Handle: Pointer; Buffer: PChar;
      MaxLength: Long; var ReadLength: Long): WordBool; cdecl;
    Handle: Pointer; // BLOb handle
    SegCount, // Number of BLOb segments
    MaxSegLength, // Max length of BLOb segment
    TotalLength: Long; // Total BLOb length
    PutSegment: procedure(Handle: Pointer; Buffer: PChar;
      Length: Long); cdecl;
    // Seek : function : Long; cdecl; // I don'n know input parameters
  end;

  PIBDateTime = ^TIBDateTime;
  TIBDateTime = record
    Days, // Date: Days since 17 November 1858
    MSec10: Integer; // Time: Millisecond * 10 since midnigth
  end;

const // Date translation constants
  MSecsPerDay10 = MSecsPerDay * 10; // Milliseconds per day * 10
  IBDateDelta = 15018; // Days between Delphi and InterBase dates

  MaxBLObPutLength = 80;

  MaxBufSize = 32768;

function FillBuffer(var BLOb: TBLOb; Buf: PChar; FreeBufLen: Integer;
  var ReadLen: Integer): Boolean; forward;

implementation

procedure BLObInfo(var BLOb: TBLOb; CString: PChar); cdecl; export;
begin
  with BLOb do
    if Assigned(Handle) then
      StrLFmt(CString, 255, // Max result string size
        'number of segments:%d  max. segment length:%d  total length:%d',
        [SegCount, MaxSegLength, TotalLength])
    else
      StrCopy(CString, '<empty BLOb>');
end;

function SearchSample(Buf, Sample: PChar): Boolean;
begin
  Result := StrPos(Buf, Sample) <> nil;
end;

function FillBuffer(var BLOb: TBLOb; Buf: PChar; FreeBufLen: Integer;
  var ReadLen: Integer): Boolean;
var
  EndOfBLOb: Boolean;
  FreeBufLenX, GotLength: Long;
begin
  try
    ReadLen := 0;
    repeat
      GotLength := 0; { !?! }

      if FreeBufLen > MaxBLObPutLength then
        FreeBufLenX := MaxBLObPutLength
      else
        FreeBufLenX := FreeBufLen;

      with BLOb do
        EndOfBLOb := not GetSegment(Handle, Buf + ReadLen, FreeBufLenX, GotLength);

      Inc(ReadLen, GotLength);
      Dec(FreeBufLen, GotLength);
    until EndOfBLOb or (FreeBufLen = 0);
  except
    on E: Exception do
      begin
        EndOfBLOb := True;
      end;
  end;
  Buf[ReadLen] := #0;
  Result := EndOfBLOb;
end;

function BLObSearch(var BLOb: TBLOb; KeyWord: PChar): Integer; cdecl; export;
var
  KeyWordLen, ReadLength, Offset: Integer;
  EndOfBLOb, Found: Boolean;
  Buf: PChar;
begin
  Result := 0;
  with BLOb do
    if (not Assigned(Handle)) or (TotalLength = 0) then
      Exit;

  Result := -2;
  KeyWordLen := StrLen(KeyWord) - 1;
  if KeyWordLen >= MaxBufSize then
    Exit;

  GetMem(Buf, MaxBufSize + 1);
  try
    Found := False;

    Result := -1;
    if not Assigned(Buf) then
      Exit;

    Offset := 0;
    repeat
      EndOfBLOb := FillBuffer(BLOb, Buf + Offset, MaxBufSize - Offset, ReadLength);

      if ReadLength + Offset >= KeyWordLen then
        begin
          Found := SearchSample(Buf, KeyWord);
          StrMove(Buf, Buf + ReadLength + Offset - KeyWordLen, KeyWordLen);
          Offset := KeyWordLen;
        end
      else
        Offset := Offset + ReadLength; // Only at the end of BLOb
    until EndOfBLOb or Found;

  finally
    FreeMem(Buf, MaxBufSize + 1);
  end;

  Result := Integer(Found);
end;

const
  MaxVarCharLength = 32767; // Max [Var]Char length

procedure BLObToCString(var BLOb: TBLOb; CString: PChar); cdecl; export;
var
  ReadLength: Integer;
begin
  try
    CString[0] := #0;
    with BLOb do
      if (not Assigned(Handle)) or (TotalLength = 0) then
        Exit;

    FillBuffer(BLOb, CString, MaxVarCharLength - 1, ReadLength);
  except
  end;
end;

procedure CStringToBLOb(CString: PChar; var BLOb: TBLOb); cdecl; export;
var
  CStringLength, PutLength: Long;
begin
  try
    CStringLength := StrLen(CString);
    if CStringLength = 0 then
      Exit; // Is it possible to set BLOb = null when
    // StrLen(CString) = 0 ?
    with BLOb do
      if not Assigned(Handle) then
        Exit;

    while CStringLength > 0 do
      begin
        if CStringLength > MaxBLObPutLength then
          PutLength := MaxBLObPutLength
        else
          PutLength := CStringLength;

        with BLOb do
          PutSegment(Handle, CString, PutLength);

        Dec(CStringLength, PutLength);
        Inc(CString, PutLength);
      end;

  except
  end;
end;

exports
  BLObInfo, BLObSearch, BLObToCString, CStringToBLOb;

end.

