unit JHBlobParser;

interface

uses Classes;

type
  TJHParser = class(TObject)
  private
    FS: TStringList;
    FPos: Integer;
    FMinWordLength: Integer;
    FOccupied: Boolean;
    function GetWordsCount: Integer;
  public
    constructor Create;
    destructor Destroy; override;
    procedure Parse(Buf: PChar; BufLen: Integer);
    procedure Reset;
    function NextWord: string;
    function EOF: Boolean;
    property WordsCount: Integer read GetWordsCount;
    //property WordList: TStringList read FS;
  end;

  TJHManager = class(TObject)
  private
    FList: TList;
    function Get(Index: Integer): TJHParser;
  public
    constructor Create;
    destructor Destroy; override;
    function CreateParser: Integer;
    procedure FreeParser(Index: integer);
    property Parser[Index: Integer]:TJHParser read Get;
  end;

var
  JHManager: TJHManager;

implementation

function RusUpperCase(const st: string): string;
var
  i: integer;
begin
  Result := st;
  for i := 1 to Length(Result) do
    if Result[i] in [#$61..#$7A, #$E0..#$FF] then
      Result[i] := Chr(Ord(Result[i]) - $20);
end;

{ TJHParser }

constructor TJHParser.Create;
begin
  FS := TStringList.Create;
  FS.Sorted := True;
  FS.Duplicates := dupIgnore;
  FS.Capacity := 500;
  FMinWordLength := 3;
end;

destructor TJHParser.Destroy;
begin
  FS.Free;
  inherited;
end;

function TJHParser.EOF: Boolean;
begin
  EOF := (FPos = FS.Count);
end;

function TJHParser.NextWord: string;
begin
  if FPos < FS.Count then
    begin
      Result := FS[FPos];
      Inc(FPos);
    end
  else
    Result := '';
end;

procedure TJHParser.Reset;
begin
  FPos := 0;
end;

procedure TJHParser.Parse(Buf: PChar; BufLen: Integer);
var
  I: Integer;
  p: PChar;
  st: string;
begin
  FS.Clear;
  p := Buf;
  I := 0;
  while I < BufLen do
    begin
      if p^ in [#$30..#$39, #$41..#$5A, #$61..#$7A, #$C0..#$FF] then
        st := st + p^
      else
        begin
          if Length(st) > FMinWordLength then
            FS.Add(rusUpperCase(st));
          st := '';
        end;
      Inc(i);
      Inc(p);
    end;
  if Length(st) > FMinWordLength then
    FS.Add(RusUpperCase(st));
end;

function TJHParser.GetWordsCount: Integer;
begin
 Result := FS.Count;
end;

{ TJHManager }

constructor TJHManager.Create;
begin
  FList := TList.Create;
end;

destructor TJHManager.Destroy;
 var i: Integer;
begin
  for i := 0 to FList.Count - 1 do
   Parser[i].Free;
  FList.Free;
  inherited;
end;

function TJHManager.CreateParser: Integer;
 var I: integer;
begin
 try
 for i := 0 to FList.Count - 1 do
  if not Parser[i].FOccupied then
   begin
    Result := i;
    Parser[i].FOccupied := True;
    Exit;
   end;
 Result := FList.Add(TJHParser.Create);
 except
  Result := -1;
 end;
end;

procedure TJHManager.FreeParser(Index: integer);
begin
 if (Index > -1) and (Index < FList.Count) then
  begin
   Parser[Index].FOccupied := False;
   Parser[Index].FS.Clear;
   Parser[Index].FPos := 0;
  end;
end;

function TJHManager.Get(Index: Integer): TJHParser;
begin
 Result := TJHParser(FList[Index]);
end;

initialization
 JHManager := TJHManager.Create;

finalization
 JHManager.Free;

end.

