{$ALIGN OFF}

unit JHParserFuncs;

interface

uses Common, JHBlobParser, SysUtils;

implementation

{ ==========================
declare external function JHPrsCreate
returns
  integer by value
entry_point 'JHPrsCreate'
module_name 'JHBlobUDF'
=============================}

function JHPrsCreate: integer; cdecl; export;
begin
  Result := JHManager.CreateParser;
end;

{ ==========================
declare external function JHPrsEOF
  integer
returns
  integer by value
entry_point 'JHPrsEOF'
module_name 'JHBlobUDF'
=============================}

function JHPrsEOF(var ParserID: Integer): Integer; cdecl; export;
begin
  Result := Integer(JHManager.Parser[ParserID].EOF)
end;

{ ==========================
declare external function JHPrsNextWord
  integer,
  cstring(50)
returns
  integer by value
entry_point 'JHPrsNextWord'
module_name 'JHBlobUDF'
=============================}

procedure JHPrsNextWord(var ParserID: Integer; ResultCStr: PChar); cdecl; export;
begin
  if not JHManager.Parser[ParserID].EOF then
    StrLFmt(ResultCStr, 50, '%s', [JHManager.Parser[ParserID].NextWord])
  else
    StrCopy(ResultCStr, '');
end;

{ ==========================
declare external function JHPrsPasrse
  integer,
  blob
returns
  integer by value
entry_point 'JHPrsPasrse'
module_name 'JHBlobUDF'
=============================}

function JHPrsPasrse(var ParserID: Integer; var inBLOB: TBlob): Integer; cdecl; export;
var
  Buf: PChar;
  CurrReads, TotalReads: Long;
  EndOfBLOb: Boolean;
begin
  Result := 1;
  try
    if (not Assigned(inBLOb.Handle)) or (inBLOb.TotalLength = 0) then
      Exit;
    GetMem(Buf, inBlob.TotalLength);
    try
      CurrReads := 0;
      TotalReads := 0;
      if not Assigned(Buf) then
        Exit;
      repeat
        EndOfBLOb := not inBlob.GetSegment(inBlob.Handle, Buf + TotalReads, inBlob.MaxSegLength, CurrReads);
        Inc(TotalReads, CurrReads);
      until EndOfBLOb;
      JHManager.Parser[ParserID].Parse(Buf, TotalReads);
    finally
      FreeMem(Buf, inBlob.TotalLength);
    end;
  except
   Result := 0;
  end;
end;

{ ==========================
declare external function JHPrsReset
  integer
returns
  integer by value
entry_point 'JHPrsReset'
module_name 'JHBlobUDF'
=============================}

function JHPrsReset(var ParserID: Integer): Integer; cdecl; export;
begin
  Result := 1;
  JHManager.Parser[ParserID].Reset;
end;

{ ==========================
declare external function JHPrsFree
  integer
returns
  integer by value
entry_point 'JHPrsFree'
module_name 'JHBlobUDF'
=============================}

function JHPrsFree(var ParserID: Integer): Integer; cdecl; export;
begin
  Result := 1;
  JHManager.FreeParser(ParserID);
end;

exports
 JHPrsCreate, JHPrsEOF, JHPrsNextWord, JHPrsPasrse, JHPrsReset, JHPrsFree;
end.

