{$ALIGN OFF}

unit JHZipFuncs;

interface

uses Common, ZLIBEX;

Var
    T: array [Byte] of Cardinal;

implementation

function IsCompressed(var inBlob: TBlob): Integer; cdecl; export;
var
  Buf: PChar;
  BufSize, Readlength: Integer;
begin
  Result := 0;
  try
    BufSize := 15;
    Getmem(Buf, BufSize + 1);
    try
      FillBuffer(inBLOb, Buf, bufSize, ReadLength);
      if Readlength > 2 then
        if (Buf^ = #$78) and ((Buf + 1)^ = #$DA) then
          Result := 1;
    finally
      FreeMem(Buf, BufSize + 1);
    end;
  except
  end
end;

procedure CompressBLOB(var inBlob, Blob: TBlob); cdecl; export;
var
  Buf, AllBuf, p: PChar;
  CurrReads, TotalReads: Long;
  TotalLen, BufLength, PutLength: Long;
  EndOfBLOb: Boolean;
begin
  try
    with inBLOb do
      if (not Assigned(Handle)) or (TotalLength = 0) then
        Exit;
    with BLOb do
      if (not Assigned(Handle)) then
        Exit;
    AllBuf := nil;
    p := nil;
    TotalLen := 0;
    GetMem(Buf, inBlob.TotalLength);
    try

      CurrReads := 0;
      TotalReads := 0;
      if not Assigned(Buf) then
        Exit;
      repeat
        EndOfBLOb := not inBlob.GetSegment(inBlob.Handle, Buf + TotalReads, inBlob.MaxSegLength, CurrReads);
        Inc(TotalReads, CurrReads);
      until EndOfBLOb;
      //BufLength := StrLen(Buf);
      ZCompress(Buf, inBlob.TotalLength, Pointer(AllBuf), BufLength, zcMax);
      p := AllBuf;
      TotalLen := BufLength;
      while BufLength > 0 do
        begin
          if BufLength > MaxBLObPutLength then
            PutLength := MaxBLObPutLength
          else
            PutLength := BufLength;
          with BLOb do
            PutSegment(Handle, Allbuf, PutLength);
          Dec(BufLength, PutLength);
          Inc(Allbuf, PutLength);
        end;
    finally
      if Assigned(p) then
        FreeMem(p, TotalLen);
      FreeMem(Buf, inBlob.TotalLength);
    end;
  except
  end;
end;

procedure DeCompressBLOB(var inBlob, Blob: TBlob); cdecl; export;
var
  Buf, AllBuf, p: PChar;
  CurrReads, TotalReads: Long;
  TotalLen, BufLength, PutLength: Long;
  EndOfBLOb: Boolean;
begin
  try
    with inBLOb do
      if (not Assigned(Handle)) or (TotalLength = 0) then
        Exit;
    with BLOb do
      if (not Assigned(Handle)) then
        Exit;
    AllBuf := nil;
    p := nil;
    TotalLen := 0;
    GetMem(Buf, inBlob.TotalLength);
    try

      CurrReads := 0;
      TotalReads := 0;
      if not Assigned(Buf) then
        Exit;
      repeat
        EndOfBLOb := not inBlob.GetSegment(inBlob.Handle, Buf + TotalReads, inBlob.MaxSegLength, CurrReads);
        Inc(TotalReads, CurrReads);
      until EndOfBLOb;
      ZDeCompress(Buf, inBlob.TotalLength, Pointer(AllBuf), BufLength);
      p := AllBuf;
      TotalLen := BufLength;
      while BufLength > 0 do
        begin
          if BufLength > MaxBLObPutLength then
            PutLength := MaxBLObPutLength
          else
            PutLength := BufLength;
          with BLOb do
            PutSegment(Handle, Allbuf, PutLength);
          Dec(BufLength, PutLength);
          Inc(Allbuf, PutLength);
        end;
    finally
      if Assigned(p) then
        FreeMem(p, TotalLen);
      FreeMem(Buf, inBlob.TotalLength);
    end;
  except
  end;
end;

procedure CRC32Next(Data: Pointer; Count: long; var CRC32: Cardinal);
var
	MyCRC32: Cardinal;
  I: Long;
	PData: ^Byte;
begin
	PData := Data;
	MyCRC32:= CRC32;
	for I:= 1 to Count do begin
		MyCRC32:= MyCRC32 shr 8 xor T[MyCRC32 and $FF xor PData^];
		Inc(PData);
	end;
	CRC32:= MyCRC32;
end;

{
DECLARE EXTERNAL FUNCTION BlobCRC
BLOB
RETURNS INTEGER BY VALUE
ENTRY_POINT 'BlobCRC' MODULE_NAME 'CRC32.dll';
}

function BlobCRC(Var AInput: TBlob): Cardinal; cdecl; export;
var P: PChar;
    Len: Long;
    init : Cardinal;
    EndOfBLOb : Boolean;
begin
  Result:=0;
  with AInput do
      if (not Assigned(Handle)) or (TotalLength = 0) then
        Exit;
  Getmem(P, AInput.MaxSegLength);
  init:=0;
  Len := 0;
  Result:= not init;
  try
     repeat
        EndOfBLOb := not AInput.GetSegment(AInput.Handle, P, AInput.MaxSegLength, Len);
        try
        if len > 0 then
          CRC32Next(P, Len, Result);
        except
        end;
      until EndOfBLOb;
  finally
    Result:= not Result;
    Freemem(p);
  end;
end;

exports
  CompressBLOB, DeCompressBLOB, IsCompressed, BlobCRC;

var I, D, J: Cardinal;

Initialization
  IsMultiThread := True;
  for I:= 0 to 255 do begin
  	D:= I;
  	for J:= 1 to 8 do
         if Odd(D)
         then D:= D shr 1 xor $EDB88320 { }
         else D:= D shr 1;
	 T[I]:= D;
  end;
end.

