unit fmMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, XPMan, ComCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    lbSize: TLabel;
    Label2: TLabel;
    lbWords: TLabel;
    pg: TProgressBar;
    Button1: TButton;
    XPManifest1: TXPManifest;
    cbTimes: TCheckBox;
    lbTimes: TLabel;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses DateUtils, JHBlobParser;

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
var
  F: TFileStream;
  B: PChar;
  tStart, tEnd: TDateTime;
  i: Integer;
  st: string;
begin
  lbTimes.Caption := '';
  pg.Visible := not cbTimes.Checked;
  F := TFileStream.Create(ExtractFilePath(ParamStr(0)) + '\data\small.txt', fmOpenRead);
  GetMem(B, F.Size + 1);
  tStart := now;
  i := JHManager.CreateParser;
  try
    F.ReadBuffer(B^, F.Size);
    JHManager.Parser[i].Parse(B, F.Size);
    lbWords.Caption := IntToStr(JHManager.Parser[i].WordsCount);
    while not JHManager.Parser[i].EOF do
     st := JHManager.Parser[i].NextWord;
    JHManager.FreeParser(i);
  finally
    tEnd := Now;
    FreeMem(B, F.Size + 1);
    F.Free;
  end;
  lbTimes.Caption := IntToStr(MilliSecondsBetween(tStart, tEnd)) + ' msec';
  pg.Visible := False;
end;

end.

