unit UnitX;

interface

function WaitForAccess: Integer;
function ReleaseAccess: Integer;

implementation
uses Windows;

var
  hMutex : THandle = 0;

function WaitForAccess: Integer;
begin
  Result := Integer(WaitForSingleObject(hMutex, 1000) <> WAIT_TIMEOUT);
  { 1 - ok, 0 - TimeOut }
end;

function ReleaseAccess: Integer;
begin
  Result := Integer(ReleaseMutex(hMutex));
  Sleep(0); // For better show. Comment it before use in real application!
end;

exports
  WaitForAccess, ReleaseAccess;

initialization
  hMutex := CreateMutex(nil, False, 'MutexForLongGenerator');
//  GetLastError;
finalization
  CloseHandle(hMutex);
end.
