create database "c:\UDFS_X.GDB" user "SYSDBA" password "m";

create table Z(
 Pk_Lo integer not null,
 Pk_Md integer not null,
 Pk_Hi integer not null,

 Ident varchar(10)

/* primary key (Pk_Lo, Pk_Md, Pk_Hi) Remove for better show. */
);

create exception Generator_OverFlow "Ah - ah...";
create exception WaitFail "Oh - oh...";

create generator Gen_Pk_Lo;
create generator Gen_Pk_Md;
create generator Gen_Pk_Hi;

set generator Gen_Pk_Lo to -100;
set generator Gen_Pk_Md to -1;
/* set generator Gen_Pk_Hi to -1; Remove comment to demonstrate overflow */


declare external function WaitForAccess
returns
  integer by value
entry_point "WaitForAccess"
module_name "UDFDemoX.dll";

declare external function ReleaseAccess
returns
  integer by value
entry_point "ReleaseAccess"
module_name "UDFDemoX.dll";

commit work;

set term ^ ;


create procedure Gen_Id3_x(Lo Integer, Md Integer, Hi Integer)
returns (Gen_Lo Integer, Gen_Md Integer, Gen_Hi Integer)
as
begin
  Gen_Lo = Gen_Id(Gen_Pk_Lo, Lo);
  Gen_Md = Gen_Id(Gen_Pk_Md, Md);
  Gen_Hi = Gen_Id(Gen_Pk_Hi, Hi);
end^


create procedure Gen_Id3
returns (Lo Integer, Md Integer, Hi Integer)
as
begin
  if (WaitForAccess() <> 1) then
    exception WaitFail;

  if (Gen_Id(Gen_Pk_Lo, 0) <> -1) then
    execute procedure Gen_Id3_x(1, 0, 0) returning_values Lo, Md, Hi;
  else if (Gen_Id(Gen_Pk_Md, 0) <> -1) then
    execute procedure Gen_Id3_x(1, 1, 0) returning_values Lo, Md, Hi;
  else if (Gen_Id(Gen_Pk_Hi, 0) <> -1) then
    execute procedure Gen_Id3_x(1, 1, 1) returning_values Lo, Md, Hi;
  else
    exception Generator_OverFlow;

  if (ReleaseAccess() <> 1) then
    LO = Lo; /* Dummy operation */
end^


create trigger Z_Before_Insert
for Z
before insert
as
begin
  execute procedure Gen_Id3 returning_values New.Pk_Lo, New.Pk_Md, New.Pk_Hi;
end^

create procedure Test(Record_Count Integer, Ident varchar(10))
as
begin
  while (Record_Count > 0) do begin
    insert into Z(Ident) values(:Ident);
    Record_Count = Record_Count - 1;
  end
end^

set term ; ^

commit work;

/*
execute procedure Test(1000, 'AAA');
execute procedure Test(1000, 'BBB');

select * from Z
select * from Z where Pk_Lo < 20
*/
