library xFTS_RTF;

{*
 * Simple RTF BLOB filter for FastTextSearch/IB
 *
 * Copyright (c) 1998-2002 by SoftLab MIL-TEC Ltd
 * Web    http://www.softcomplete.com
 * Email  support@softcomplete.com
 *
 *}

uses
  Windows,
  SysUtils,
  Classes;

type
  {BLOB control structure}
  TBlobGetSegment = function (AHandle: pointer; var ABuffer;
    ABufSize: Word; var AResultSize: word): word; cdecl;
  TBlobPutSegment = procedure(AHandle: pointer; var ABuffer;
    ABufSize: Word); cdecl;

  PBlob = ^TBlob;
  TBlob = record
    BlobGetSegment: TBlobGetSegment;
    BlobHandle: pointer;
    NumberSegments,
    MaxSegLen,
    TotalSize: Integer;
    BlobPutSegment: TBlobPutSegment;
  end;

function RTFToTxt(source: PChar; Len: integer): string;
const
  BufLenInc = 4096;
var
  p: integer;
  c: char;
  lastChar: char;
  token: string;
  controlWord: boolean;
  resPos: integer;

  procedure Add2Res(const S: string);
  begin
    if resPos > Length(Result) then SetLength(Result,Length(Result)+BufLenInc);
    Move(S[1],Result[resPos],Length(S));
    Inc(resPos,Length(S));
  end;

  procedure Add2ResCh(C: Char);
  begin
    if resPos > Length(Result) then SetLength(Result,Length(Result)+BufLenInc);
    Result[resPos]:=C;
    Inc(resPos);
  end;

  function Token2Str(token: string): string;
  const HexStr = '0123456789abcdef';
  var level: integer;
  begin
    token:=LowerCase(token);
    if (Length(token) >= 3) and (token[1] = '''') then
      Result:=Chr(16*(Pos(token[2],HexStr)-1)+Pos(token[3],HexStr)-1)
    else if token = 'tab' then result := #9
    else if token = 'rdblquot' then result := '"'
    else if token = 'rquote' then result := ''''
    else if token = 'ldblquot' then result := '"'
    else if token = 'lquote' then result := ''''
    else if token = 'par' then result := #13#10
    else if token = 'qc' then result := ' '
    else if token = 'pard' then result := ' '
    else if (token = 'stylesheet') or
        (token = 'fonttbl') or (token = 'listtable') or
        (token = 'colortbl') or (token = 'info') then begin
      level:=1;
      while (level > 0) and (p < Len-2) do begin
        if source[p] = '{' then Inc(level)
        else if source[p] = '}' then Dec(level);
        Inc(p);
      end;
      c:=source[p];
      lastChar:=source[p-1];
      //controlWord:=False;
      controlWord:=c in ['{','}','\'];
      result := '';
    end else result := '';
  end;

begin
  result := '';
  resPos := 1;
  controlWord := True;
  p := 0;
  c := source[p];
  lastChar := ' ';
  token := '';
  while p < Len-2 do begin
    if controlWord then // process control word
      case c of
        'a'..'z', '0'..'9', '-', '*':
          token := token + c;
        '''': begin
          Inc(p,2);
          Add2Res(Token2Str(c+source[p-1]+source[p]));
          controlWord := false;
        end;
        else begin // end of control word
          if token <> '' then Add2Res(Token2Str(token));
          if c = ' ' then controlWord := false;
          token := '';
        end;
      end
    else
      Add2ResCh(c);
    if c = '}' then controlWord := false;
    // read next character
    lastChar := c;
    Inc(p);
    c := source[p];
    if c in ['{','}','\'] then controlWord := true;
    if (lastchar = '\') and (c in ['{','}','\']) then begin
      controlWord := false;
      Add2ResCh(c);
      lastChar := c;
      Inc(p);
      c := source[p];
      if c in ['{','}','\'] then controlWord := true;
    end;
  end;
  SetLength(Result,resPos-1);
end;

function Parser_Add(var SID: integer; Str: PChar): integer; cdecl; export;
 external 'XFTS.DLL' name 'Parser_Add';
 
{
DECLARE EXTERNAL FUNCTION Parser_AddBlobRTF
    INTEGER, BLOB
    RETURNS INTEGER BY VALUE
  ENTRY_POINT "Parser_AddBlobRTF"  MODULE_NAME "XFTS_RTF.DLL";
}
function Parser_AddBlobRTF(var SID: integer; const BLOB: PBlob): integer; cdecl; export;
var P,P1: PChar;
    Len: Word;
begin
  Result:=0;
  if Assigned(BLOB) and Assigned(BLOB^.BlobHandle) and Assigned(BLOB^.BlobGetSegment) then begin
    Getmem(P, BLOB^.TotalSize+1); // +1 for /0 terminator
    try
      P1:=P;
      while BLOB^.BlobGetSegment(BLOB^.BlobHandle, P1^,BLOB^.MaxSegLen, Len) <> 0 do
        Inc(P1,Len);
      P1^:=#0;
      Result:=Parser_Add(SID,PChar(RTFToTxt(P,P1-P)));
    finally
      FreeMem(P);
    end;
  end;
end;

exports
  Parser_AddBlobRTF;

begin
  isMultiThread:=True;
end.
