/*
 * FastTextSearch for InterBase 1.5 from 3 Sep 2002
 *
 * Copyright (c) 1998-2002 by SoftLab MIL-TEC Ltd
 * Web    http://www.softcomplete.com
 * Email  support@softcomplete.com
 *
 * This script add FTS(FastTextSearch) capabilities to exists
 * database. Before execute it you must copy xLibUDF.dll and xFTS.dll
 * to directory Interbase\lib.
 */

/* CHANGE database name, username and password in next line */
connect 'database.gdb' user 'SYSDBA' password 'masterkey';

/* Generator Definitions */

CREATE GENERATOR UID;

/* External Function Declarations */

/* function StrTrim(CStr: PChar): PChar; 
*/
DECLARE EXTERNAL FUNCTION StrTrim
    CSTRING(255)
    RETURNS CSTRING(255) FREE_IT
  ENTRY_POINT 'StrTrim'  MODULE_NAME 'XLIBUDF.DLL';

/* function StrUCase(CStr: PChar): PChar;
*/
DECLARE EXTERNAL FUNCTION StrUCase
    CSTRING(255)
    RETURNS CSTRING(255) 
  ENTRY_POINT 'StrUCase'  MODULE_NAME 'XLIBUDF.DLL';

/* function StrLCase(CStr: PChar): PChar; 
*/
DECLARE EXTERNAL FUNCTION StrLCase
    CSTRING(255)
    RETURNS CSTRING(255)
  ENTRY_POINT 'StrLCase'  MODULE_NAME 'XLIBUDF.DLL';

/* function StrLength(S: pchar): integer; 
*/
DECLARE EXTERNAL FUNCTION StrLength
    CSTRING(255)
    RETURNS INTEGER BY VALUE
  ENTRY_POINT 'StrLength'  MODULE_NAME 'XLIBUDF.DLL';

/* function SubStr(CString: PChar; var FromPos, SubLen: Integer): PChar;
*/
DECLARE EXTERNAL FUNCTION SubStr
    CSTRING(255), INTEGER, INTEGER
    RETURNS CSTRING(255) 
  ENTRY_POINT 'SubStr'  MODULE_NAME 'XLIBUDF.DLL';

/* function StrFirst(CString: PChar; var SubLen: Integer): PChar;
*/
DECLARE EXTERNAL FUNCTION StrFirst
    CSTRING(255), INTEGER
    RETURNS CSTRING(255)
  ENTRY_POINT 'StrFirst'  MODULE_NAME 'XLIBUDF.DLL';

/* function StrLast(CString: PChar; var SubLen: Integer): PChar;
*/
DECLARE EXTERNAL FUNCTION StrLast
    CSTRING(255), INTEGER
    RETURNS CSTRING(255) 
  ENTRY_POINT 'StrLast'  MODULE_NAME 'XLIBUDF.DLL';

/* function ANSILike(Src,MathStr: PChar): integer;
*/
DECLARE EXTERNAL FUNCTION ANSILike
    CSTRING(255), CSTRING(255)
    RETURNS INTEGER BY VALUE
  ENTRY_POINT 'ANSILike'  MODULE_NAME 'XLIBUDF.DLL';

/* function CreateUID: pchar; 
*/
DECLARE EXTERNAL FUNCTION CreateUID
    RETURNS CSTRING(32) FREE_IT
  ENTRY_POINT 'CreateUID'  MODULE_NAME 'XLIBUDF.DLL';

/* function WaitMutex(MutexName: PChar; Timeout: integer): Integer;
   1 - OK, 0 - TimeOut
*/
DECLARE EXTERNAL FUNCTION WaitMutex
    CSTRING(255), INTEGER
    RETURNS INTEGER BY VALUE
  ENTRY_POINT 'WaitMutex'  MODULE_NAME 'XLIBUDF.DLL';

/* function FreeMutex(MutexName: PChar): integer;
*/
DECLARE EXTERNAL FUNCTION FreeMutex
    CSTRING(255), INTEGER
    RETURNS INTEGER BY VALUE
  ENTRY_POINT 'FreeMutex'  MODULE_NAME 'XLIBUDF.DLL';

/* function WriteDebug(FileName,Str: pchar): integer; 
*/
DECLARE EXTERNAL FUNCTION WriteDebug
    CSTRING(255)
    RETURNS INTEGER BY VALUE
  ENTRY_POINT 'WriteDebug'  MODULE_NAME 'XLIBUDF.DLL';

DECLARE EXTERNAL FUNCTION Parser_Create
    RETURNS INTEGER BY VALUE
  ENTRY_POINT 'Parser_Create'  MODULE_NAME 'XFTS.DLL';

DECLARE EXTERNAL FUNCTION Parser_CreateQuery
    RETURNS INTEGER BY VALUE
  ENTRY_POINT 'Parser_CreateQuery'  MODULE_NAME 'XFTS.DLL';

DECLARE EXTERNAL FUNCTION Parser_Free
    INTEGER
    RETURNS INTEGER BY VALUE
  ENTRY_POINT 'Parser_Free'  MODULE_NAME 'XFTS.DLL';

DECLARE EXTERNAL FUNCTION Parser_Add
    INTEGER, CSTRING(4096)
    RETURNS INTEGER BY VALUE
  ENTRY_POINT 'Parser_Add'  MODULE_NAME 'XFTS.DLL';

DECLARE EXTERNAL FUNCTION Parser_AddBlob
    INTEGER, BLOB
    RETURNS INTEGER BY VALUE
  ENTRY_POINT 'Parser_AddBlob'  MODULE_NAME 'XFTS.DLL';

DECLARE EXTERNAL FUNCTION Parser_CRC
    INTEGER
    RETURNS INTEGER BY VALUE
  ENTRY_POINT 'Parser_CRC'  MODULE_NAME 'XFTS.DLL';

DECLARE EXTERNAL FUNCTION Parser_Reset
    INTEGER
    RETURNS INTEGER BY VALUE
  ENTRY_POINT 'Parser_Reset'  MODULE_NAME 'XFTS.DLL';

DECLARE EXTERNAL FUNCTION Parser_Next
    INTEGER
    RETURNS CSTRING(32) FREE_IT
  ENTRY_POINT 'Parser_Next'  MODULE_NAME 'XFTS.DLL';


DECLARE EXTERNAL FUNCTION StrSoundEX
    CSTRING(256)
    RETURNS INTEGER BY VALUE
  ENTRY_POINT 'StrSoundEX'  MODULE_NAME 'XFTS.DLL';

/* Domains declarations */

CREATE DOMAIN T$VC32 AS VARCHAR(32) default '' NOT NULL ;

/* Tables Definitions */

/* Table: TS$LINK */
CREATE TABLE TS$LINK (WORD_ID INTEGER NOT NULL,
        OBJ_ID INTEGER NOT NULL,
CONSTRAINT PK_TS$LINK PRIMARY KEY (WORD_ID, OBJ_ID));

/* Table: TS$OBJ */
CREATE TABLE TS$OBJ (ID INTEGER NOT NULL,
        OBJ_TYPE VARCHAR(32) NOT NULL,
        CRC INTEGER NOT NULL,
CONSTRAINT PK_TS$OBJ PRIMARY KEY (ID));

/* Table: TS$OPT */
CREATE TABLE TS$OPT (ENABLE SMALLINT NOT NULL);

/* Table: TS$QUERY */
CREATE TABLE TS$QUERY (ID INTEGER NOT NULL,
        WORD T$VC32 NOT NULL,
        SND_CODE INTEGER NOT NULL,
CONSTRAINT PK_TS$QUERY PRIMARY KEY (ID, WORD));

/* Table: TS$VOCAB */
CREATE TABLE TS$VOCAB (ID INTEGER NOT NULL,
        WORD T$VC32 NOT NULL,
        SND_CODE INTEGER NOT NULL,
CONSTRAINT PK_TS$VOCAB PRIMARY KEY (ID));


/* Index Definitions For All Users Tables */

CREATE INDEX TS$OBJ_IDX1 ON TS$OBJ (OBJ_TYPE);
CREATE UNIQUE INDEX TS$VOCAB_IDX1 ON TS$VOCAB (WORD);
CREATE INDEX TS$VOCAB_IDX_SND ON TS$VOCAB (SND_CODE);
ALTER TABLE TS$LINK ADD CONSTRAINT FK_TS$LINK FOREIGN KEY (WORD_ID) REFERENCES TS$VOCAB(ID) ON DELETE CASCADE ON UPDATE CASCADE;
ALTER TABLE TS$LINK ADD CONSTRAINT FK_TS$LINK_OBJ FOREIGN KEY (OBJ_ID) REFERENCES TS$OBJ(ID) ON DELETE CASCADE ON UPDATE CASCADE;

/* Stored Procedure Definitions */

set term ^ ;

/* Procedure: TS$ADD_LINK */
CREATE PROCEDURE TS$ADD_LINK(
    WORD VARCHAR(32),
    OBJ_ID INTEGER
)
AS BEGIN EXIT; END ^

/* Procedure: TS$ADD_WORD */
CREATE PROCEDURE TS$ADD_WORD(
    WORD VARCHAR(32)
)
RETURNS (
    WORD_ID INTEGER
)
AS BEGIN EXIT; END ^

/* Procedure: TS$PACK_VOCAB */
CREATE PROCEDURE TS$PACK_VOCAB
AS BEGIN EXIT; END ^

/* Procedure: TS$SELECT_AND */
CREATE PROCEDURE TS$SELECT_AND(
    OBJ_TYPE VARCHAR(32),
    WORDS VARCHAR(512),
    SOUNDEXFLAG INTEGER
)
RETURNS (
    OBJ_ID INTEGER
)
AS BEGIN EXIT; END ^

/* Procedure: TS$SELECT_AND1 */
CREATE PROCEDURE TS$SELECT_AND1(
    OBJ_TYPE VARCHAR(32),
    QID INTEGER,
    SOUNDEXFLAG INTEGER
)
RETURNS (
    WORD_ID INTEGER,
    OBJ_ID INTEGER
)
AS BEGIN EXIT; END ^

/* Procedure: TS$SELECT_OR */
CREATE PROCEDURE TS$SELECT_OR(
    OBJ_TYPE VARCHAR(32),
    WORDS VARCHAR(512),
    SOUNDEXFLAG INTEGER
)
RETURNS (
    OBJ_ID INTEGER
)
AS BEGIN EXIT; END ^

/* Procedure: TS$UPDATE */
CREATE PROCEDURE TS$UPDATE(
    OBJ_ID INTEGER,
    OBJ_TYPE VARCHAR(32),
    PARSER INTEGER
)
RETURNS (
    OID INTEGER
)
AS BEGIN EXIT; END ^

/* Procedure: TS$UPDATE_OBJ */
CREATE PROCEDURE TS$UPDATE_OBJ(
    OBJ_ID INTEGER,
    PARSER INTEGER
)
AS BEGIN EXIT; END ^

/* Procedure: TS$ADD_LINK, Owner: SYSDBA */
ALTER PROCEDURE TS$ADD_LINK(
    WORD VARCHAR(32),
    OBJ_ID INTEGER
)
AS
 
declare variable word_id integer;
begin
  execute procedure TS$ADD_WORD(:word) RETURNING_VALUES :word_id;
  if (not exists(select word_id from TS$LINK 
      where word_id=:word_id and obj_id=:obj_id)) then
    insert into TS$LINK 
      (word_id, obj_id)
      values
      (:word_id, :obj_id);
end
^

/* Procedure: TS$ADD_WORD, Owner: SYSDBA */
ALTER PROCEDURE TS$ADD_WORD(
    WORD VARCHAR(32)
)
RETURNS (
    WORD_ID INTEGER
)
AS
 
begin
  select id 
    from ts$vocab
    where word = :word
    into :word_id;
  if (word_id is null) then begin
    insert into ts$vocab
      (word) values (:word);
    select id 
      from ts$vocab
      where word = :word
      into :word_id;
  end
end
^

/* Procedure: TS$PACK_VOCAB, Owner: SYSDBA */
ALTER PROCEDURE TS$PACK_VOCAB
AS
 
begin
  delete from TS$VOCAB V
    where not exists(select WORD_ID from TS$LINK where WORD_ID = V.ID);
end
^

/* Procedure: TS$SELECT_AND, Owner: SYSDBA */
ALTER PROCEDURE TS$SELECT_AND(
    OBJ_TYPE VARCHAR(32),
    WORDS VARCHAR(512),
    SOUNDEXFLAG INTEGER
)
RETURNS (
    OBJ_ID INTEGER
)
AS
declare variable Parser integer;
declare variable i integer;
declare variable qID integer;
declare variable qCount integer;
declare variable cnt integer;
declare variable word varchar(32);
declare variable wordnext varchar(32);
declare variable wsex integer;
declare variable o_type varchar(32);
begin
  qID=Gen_ID(UID,1);
  delete from TS$Query where id=:qID;
  OBJ_TYPE=StrUCase(OBJ_TYPE);
  Parser=Parser_CreateQuery();
  i=Parser_Add(Parser,WORDS);
  i=Parser_Reset(Parser);
  wordnext=Parser_Next(Parser);
  while ((wordnext is not null) and (wordnext <> '')) do begin
    word=wordnext;
    wsex=StrSoundEX(word);
    insert into TS$Query
      (ID,WORD,SND_CODE)
    values
      (:qID,:word,:wsex);
    wordnext=Parser_Next(Parser);
  end
  i=Parser_Free(Parser);
  qCount=0;
  select Count(*) from TS$Query where ID=:qID into :qCount;
  if (qCount > 0) then
    if (qCount =  1) then begin
        if (SoundExFlag = 1) then
          for 
            select distinct L.obj_id
              from TS$LINK L, TS$VOCAB V
              where V.SND_CODE = :wsex
                and L.word_id = V.id
            into :OBJ_ID
            do begin
              select obj_type from ts$obj where id=:obj_id into :o_type;
              if (o_type = obj_type) then suspend;
            end
        else
          for 
            select distinct L.obj_id
              from TS$LINK L, TS$VOCAB V
              where V.WORD >= :WORD
                and V.WORD starting with :WORD
                and L.word_id = V.id
            into :OBJ_ID
            do begin
              select obj_type from ts$obj where id=:obj_id into :o_type;
              if (o_type = obj_type) then suspend;
            end
    end else 
      for
        select OBJ_ID, Count(*)
          from ts$select_and1(:OBJ_TYPE,:qID,:SoundExFlag)
          group by OBJ_ID
        into :OBJ_ID, :cnt
        do if (cnt = qCount) then suspend;
  delete from TS$Query where id=:qID;  
end
^

/* Procedure: TS$SELECT_AND1, Owner: SYSDBA */
ALTER PROCEDURE TS$SELECT_AND1(
    OBJ_TYPE VARCHAR(32),
    QID INTEGER,
    SOUNDEXFLAG INTEGER
)
RETURNS (
    WORD_ID INTEGER,
    OBJ_ID INTEGER
)
AS
declare variable o_type varchar(32);
begin
  if (SoundExFlag = 1) then
    for 
      select distinct V.ID, L.obj_id
        from TS$LINK L, TS$VOCAB V, TS$QUERY Q
        where V.SND_CODE = Q.SND_CODE
          and Q.ID = :qID
          and L.word_id = V.id
      into :WORD_ID,:OBJ_ID
        do begin
          select obj_type from ts$obj where id=:obj_id into :o_type;
          if (o_type = obj_type) then suspend;
        end
  else
    for 
      select distinct V.ID, L.obj_id
        from TS$LINK L, TS$VOCAB V, TS$QUERY Q
        where V.WORD >= Q.WORD
          and V.WORD starting with Q.WORD
          and Q.ID = :qID
          and L.word_id = V.id
      into :WORD_ID,:OBJ_ID
        do begin
          select obj_type from ts$obj where id=:obj_id into :o_type;
          if (o_type = obj_type) then suspend;
        end
end
^

/* Procedure: TS$SELECT_OR, Owner: SYSDBA */
ALTER PROCEDURE TS$SELECT_OR(
    OBJ_TYPE VARCHAR(32),
    WORDS VARCHAR(512),
    SOUNDEXFLAG INTEGER
)
RETURNS (
    OBJ_ID INTEGER
)
AS
declare variable Parser integer;
declare variable i integer;
declare variable qID integer;
declare variable wcnt integer;
declare variable wsex integer;
declare variable word varchar(32);
declare variable wordnext varchar(32);
declare variable o_type varchar(32);
begin
  qID=Gen_ID(UID,1);
  delete from TS$Query where id=:qID;
  OBJ_TYPE=StrUCase(OBJ_TYPE);
  Parser=Parser_CreateQuery();
  i=Parser_Add(Parser,WORDS);
  i=Parser_Reset(Parser);
  wcnt=0;
  wordnext=Parser_Next(Parser);
  while ((wordnext is not null) and (wordnext <> '')) do begin
    word=wordnext;
    wsex=StrSoundEX(word);
    insert into TS$Query
      (ID,WORD,SND_CODE)
    values
      (:qID,:word,:wsex);
    wcnt=wcnt+1;
    wordnext=Parser_Next(Parser);
  end
  i=Parser_Free(Parser);
  if (wcnt = 1) then
    if (SoundExFlag = 1) then
      for 
        select distinct L.obj_id
          from TS$LINK L, TS$VOCAB V
          where V.SND_CODE = :wsex
            and L.word_id = V.id
        into :OBJ_ID
        do begin
          select obj_type from ts$obj where id=:obj_id into :o_type;
          if (o_type = obj_type) then suspend;
        end
    else
      for 
        select distinct L.obj_id
          from TS$LINK L, TS$VOCAB V
          where V.WORD >= :WORD
            and V.WORD starting with :WORD
            and L.word_id = V.id
        into :OBJ_ID
        do begin
          select obj_type from ts$obj where id=:obj_id into :o_type;
          if (o_type = obj_type) then suspend;
        end
  else if (wcnt > 1) then
    if (SoundExFlag = 1) then
      for 
        select distinct L.obj_id
          from TS$LINK L, TS$VOCAB V, TS$QUERY Q
          where V.SND_CODE = Q.SND_CODE
            and Q.ID = :qID
            and L.word_id = V.id
        into :OBJ_ID
        do begin
          select obj_type from ts$obj where id=:obj_id into :o_type;
          if (o_type = obj_type) then suspend;
        end
    else
      for 
        select distinct L.obj_id
          from TS$LINK L, TS$VOCAB V, TS$QUERY Q
          where V.WORD >= Q.WORD
            and V.WORD starting with Q.WORD
            and Q.ID = :qID
            and L.word_id = V.id
        into :OBJ_ID
        do begin
          select obj_type from ts$obj where id=:obj_id into :o_type;
          if (o_type = obj_type) then suspend;
        end
  delete from TS$Query where id=:qID;
end
^

/* Procedure: TS$UPDATE, Owner: SYSDBA */
ALTER PROCEDURE TS$UPDATE(
    OBJ_ID INTEGER,
    OBJ_TYPE VARCHAR(32),
    PARSER INTEGER
)
RETURNS (
    OID INTEGER
)
AS
declare variable CRC integer;
declare variable oldCRC integer;
begin
  OBJ_TYPE=StrUCase(OBJ_TYPE);
  CRC=Parser_CRC(Parser);
  oid=obj_id;
  if ((oid is null) or 
      not exists(select id from ts$obj
      where id=:oid and obj_type=:obj_type)) then begin
    oid=Gen_ID(UID,1);
    insert into TS$OBJ
      (id,obj_type,CRC)
      values
      (:oid,:obj_type,:CRC);
    execute procedure ts$update_obj(:oid,:Parser);
  end else begin
    select CRC
      from TS$OBJ
      where ID = :oid and obj_type = :obj_type
      into :oldCRC;
    if (oldCRC <> CRC) then begin 
      execute procedure ts$update_obj(:oid,:Parser);
      update TS$OBJ
        set CRC = :CRC
        where id = :oid and obj_type = :obj_type;
    end 
  end
end
^

/* Procedure: TS$UPDATE_OBJ, Owner: SYSDBA */
ALTER PROCEDURE TS$UPDATE_OBJ(
    OBJ_ID INTEGER,
    PARSER INTEGER
)
AS
 
declare variable i integer;
declare variable word varchar(32);
begin
  delete from TS$LINK
    where OBJ_ID = :obj_id;
  if (Parser > 0) then begin
    i=Parser_Reset(Parser);
    word=Parser_Next(Parser);
    while ((word is not null) and (word <> '')) do begin
      execute procedure ts$add_link(:word,:obj_id);
      word=Parser_Next(Parser);
    end
  end
end
^

set term ; ^

/* Triggers Definitions */

set term ^ ;

CREATE TRIGGER T_BI_TS$VOCAB FOR TS$VOCAB
ACTIVE BEFORE INSERT POSITION 0
as
begin
  IF (new.ID is null) THEN BEGIN
    new.ID = Gen_ID(UID,1);
  END
  new.WORD=StrUCase(new.WORD);
  new.SND_CODE=StrSoundEX(new.WORD);
end
^

CREATE TRIGGER T_BU_TS$VOCAB FOR TS$VOCAB
ACTIVE BEFORE UPDATE POSITION 0
as
begin
  new.id=old.id;
  new.WORD=StrUCase(new.WORD);
  new.SND_CODE=StrSoundEX(new.WORD);
end
^

set term ; ^

commit work;

/* enable FTS */
INSERT INTO TS$OPT (ENABLE) VALUES (1);

commit work;
