<?php

namespace Illuminate\Database\Connectors;

use PDO;

class FirebirdConnector extends Connector implements ConnectorInterface {
    
    /**
     * The default PDO connection options.
     *
     * @var array
     */
    protected $options = [
        PDO::ATTR_CASE => PDO::CASE_NATURAL,
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_ORACLE_NULLS => PDO::NULL_NATURAL,
        PDO::ATTR_STRINGIFY_FETCHES => true,
        PDO::ATTR_EMULATE_PREPARES => false,
    ];    

    /**
     * Establish a database connection.
     *
     * @param  array  $config
     * @return \PDO
     */
    public function connect(array $config) {
        $dsn = $this->getDsn($config);

        $options = $this->getOptions($config);

        // We need to grab the PDO options that should be used while making the brand
        // new connection instance. The PDO options control various aspects of the
        // connection's behavior, and some might be specified by the developers.
        $connection = $this->createConnection($dsn, $config, $options);

        return $connection;
    }

    /**
     * Create a DSN string from a configuration.
     *
     * @param  array   $config
     * @return string
     */
    protected function getDsn(array $config) {
        $dsn = "firebird:dbname=";
        if (isset($config['host'])) {
            $dsn .= $config['host'];
        }
        if (isset($config['port'])) {
            $dsn .= "/" . $config['port'];
        }
        $dsn .= ":" . $config['database'] . ';';
        if (isset($config['charset'])) {
            $dsn .= "charset=" . $config['charset'];
        }     
        if (isset($config['role'])) {
            $dsn .= ";role=" . $config['role'];
        }   
        
        return $dsn;
    }
     

}
